/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.jdbc;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.mule.util.MiscUtil;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class JdbcScriptEngine {
    private static final Logger log = LoggerFactory.getLogger(JdbcScriptEngine.class);
    private SimpleJdbcTemplate t;

    public JdbcScriptEngine(DataSource ds) {
        this.t = new SimpleJdbcTemplate(ds);
    }

    public void execute(String scriptFilename) throws FileNotFoundException {
        this.execute(scriptFilename, false);
    }

    public void execute(String scriptFilename, boolean ignoreErrors) throws FileNotFoundException {
        String[] sqlArr;
        String s = MiscUtil.convertStreamToString(new FileInputStream(scriptFilename));
        log.info("Execute JDBC-scriptfile: {}", (Object)scriptFilename);
        for (String sql : sqlArr = s.split(";")) {
            if (sql == null || sql.trim().length() <= 0) continue;
            try {
                log.debug("Execute: {}", (Object)sql);
                this.t.getJdbcOperations().execute(sql);
            }
            catch (RuntimeException e) {
                if (ignoreErrors) {
                    log.debug("Ignore failed to execute sql command [" + sql + "], error: " + e.getMessage());
                    continue;
                }
                log.warn("Failed to execute sql command [" + sql + "], error: " + e.getMessage());
                throw e;
            }
        }
        log.info("Done executing JDBC-scriptfile: {}", (Object)scriptFilename);
    }
}

