/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.mime;

import java.io.File;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeUtil {
    private static final Logger logger = LoggerFactory.getLogger(MimeUtil.class);

    private MimeUtil() {
        throw new UnsupportedOperationException("Not allowed to create an instance of this class");
    }

    public static String sendFileAsMultipartHttpPost(String targetURL, File targetFile, boolean expectHeader, int timeoutMs) {
        return MimeUtil.sendFileAsMultipartHttpPost(targetURL, targetFile, targetFile.getName(), expectHeader, timeoutMs);
    }

    public static String sendFileAsMultipartHttpPost(String targetURL, File targetFile, String partName, boolean expectHeader, int timeoutMs) {
        String response;
        block6: {
            logger.debug("Send file {} to url {}", (Object)targetFile.getAbsolutePath(), (Object)targetURL);
            response = null;
            PostMethod filePost = new PostMethod(targetURL);
            filePost.getParams().setBooleanParameter("http.protocol.expect-continue", expectHeader);
            try {
                Part[] parts = new Part[]{new FilePart(partName, targetFile)};
                filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
                HttpClient client = new HttpClient();
                client.getHttpConnectionManager().getParams().setConnectionTimeout(timeoutMs);
                int status = client.executeMethod((HttpMethod)filePost);
                logger.debug("Send done, http status: {}", (Object)status);
                if (status == 200) {
                    response = filePost.getResponseBodyAsString();
                    logger.debug("Send done, http response: {}", (Object)response);
                    break block6;
                }
                String errorText = HttpStatus.getStatusText((int)status);
                throw new RuntimeException("HTTP Error Code: " + status + "HTTP Error Text: " + errorText);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                filePost.releaseConnection();
            }
        }
        return response;
    }
}

