/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.cert;

import java.util.Arrays;
import java.util.List;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.mule.cert.X509CertificateEvaluator;

public class ValidateSenderIdTransformer
extends AbstractMessageTransformer
implements MuleContextAware {
    private static final Logger log = LoggerFactory.getLogger(ValidateSenderIdTransformer.class);
    private String senderIdPropertyName;
    private List<String> validSenderIds;

    public void setSenderIdPropertyName(String senderIdPropertyName) {
        this.senderIdPropertyName = senderIdPropertyName;
    }

    public void setValidSenderIds(String validSenderIds) {
        this.validSenderIds = Arrays.asList(validSenderIds.split(","));
    }

    protected X509CertificateEvaluator getX509CertificateEvaluator(String property) {
        X509CertificateEvaluator eval = new X509CertificateEvaluator();
        eval.setPropertyName(this.senderIdPropertyName);
        return eval;
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        X509CertificateEvaluator eval = this.getX509CertificateEvaluator(this.senderIdPropertyName);
        String senderId = (String)eval.evaluate("sender-id", message);
        if (senderId != null) {
            message.setSessionProperty("Sender", (Object)senderId);
        } else {
            message.setSessionProperty("Sender", (Object)"");
        }
        if (this.validSenderIds.contains(senderId)) {
            log.debug("{} is a valid senderId!", (Object)senderId);
        } else {
            this.logAndThrowError("Invalid senderId [" + senderId + "], allowed senderIds are: " + this.validSenderIds);
        }
        return message;
    }

    private void logAndThrowError(String errorMessage) throws TransformerException {
        this.logger.error((Object)errorMessage);
        throw new TransformerException((Transformer)this, (Throwable)new RuntimeException(errorMessage));
    }
}

