/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.rest;

import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;

public class RestClient {
    private MuleClient muleClient;
    private String muleConnector;

    public RestClient(MuleContext muleContext, String muleConnector) {
        try {
            this.muleClient = new MuleClient(muleContext);
            this.muleConnector = muleConnector;
        }
        catch (MuleException e) {
            throw new RuntimeException(e);
        }
    }

    public RestClient(MuleContext muleContext) {
        try {
            this.muleClient = new MuleClient(muleContext);
            this.muleConnector = null;
        }
        catch (MuleException e) {
            throw new RuntimeException(e);
        }
    }

    public MuleMessage doHttpPostRequest_JsonContent(String url, String payload) {
        return this.doHttpSendRequest(url, "POST", payload, "application/json;charset=utf-8");
    }

    public MuleMessage doHttpPostRequest_XmlContent(String url, String payload) {
        return this.doHttpSendRequest(url, "POST", payload, "application/xml;charset=utf-8");
    }

    public MuleMessage doHttpGetRequest_JsonContent(String url) {
        return this.doHttpReceiveRequest(url, "GET", "application/json", "utf-8");
    }

    public MuleMessage doHttpGetRequest_XmlContent(String url) {
        return this.doHttpReceiveRequest(url, "GET", "application/xml", "utf-8");
    }

    public MuleMessage doHttpPutRequest_JsonContent(String url, String payload) {
        return this.doHttpSendRequest(url, "PUT", payload, "application/json;charset=utf-8");
    }

    public MuleMessage doHttpPutRequest_XmlContent(String url, String payload) {
        return this.doHttpSendRequest(url, "PUT", payload, "application/xml;charset=utf-8");
    }

    public MuleMessage doHttpDeleteRequest_JsonContent(String url) {
        return this.doHttpReceiveRequest(url, "DELETE", "application/json", "utf-8");
    }

    public MuleMessage doHttpDeleteRequest_XmlContent(String url) {
        return this.doHttpReceiveRequest(url, "DELETE", "application/xml", "utf-8");
    }

    public MuleMessage doHttpSendRequest(String url, String method, String payload, String contentType) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("http.method", method);
        properties.put("Content-Type", contentType);
        MuleMessage response = this.send(url, payload, properties);
        return response;
    }

    public MuleMessage doHttpReceiveRequest(String url, String method, String acceptConentType, String acceptCharSet) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("http.method", method);
        properties.put("Accept", acceptConentType);
        properties.put("Accept-Charset", acceptCharSet);
        MuleMessage response = this.send(url, null, properties);
        return response;
    }

    private MuleMessage send(String url, String payload, Map<String, String> properties) {
        if (this.muleConnector != null) {
            url = url + "?connector=" + this.muleConnector;
        }
        try {
            return this.muleClient.send(url, (Object)payload, properties);
        }
        catch (MuleException e) {
            throw new RuntimeException(e);
        }
    }
}

