/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XPathUtil {
    private static final Logger log = LoggerFactory.getLogger(XPathUtil.class);

    private XPathUtil() {
        throw new UnsupportedOperationException("Not allowed to create an instance of this class");
    }

    public static Document createDocument(InputStream content) {
        try {
            return XPathUtil.getBuilder().parse(content);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Document createDocument(String content) {
        return XPathUtil.createDocument(content, "UTF-8");
    }

    public static Document createDocument(String content, String charset) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes(charset));
            return XPathUtil.getBuilder().parse(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static DocumentBuilder getBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        return builder;
    }

    public static String getDocumentComment(Document doc) {
        String docComment = null;
        try {
            NodeList childs = doc.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node child = childs.item(i);
                if (child.getNodeType() != 8) continue;
                docComment = child.getNodeValue();
            }
            return docComment;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static NodeList getXPathResult(Node node, String namespacePrefix, String namespaceURI, String expression) {
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        namespaceMap.put(namespacePrefix, namespaceURI);
        return XPathUtil.getXPathResult(node, namespaceMap, expression);
    }

    public static NodeList getXPathResult(Node node, Map<String, String> namespaceMap, String expression) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            if (namespaceMap != null) {
                xpath.setNamespaceContext(new MapNamespaceContext(namespaceMap));
            }
            XPathExpression expr = xpath.compile(expression);
            Object result = expr.evaluate(node, XPathConstants.NODESET);
            return (NodeList)result;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFirstValue(NodeList nodes) {
        return nodes.getLength() == 0 ? null : XPathUtil.getValues(nodes).get(0);
    }

    public static List<String> getValues(NodeList nodes) {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            values.add(nodes.item(i).getNodeValue());
        }
        return values;
    }

    public static void appendXmlFragment(Node parent, String fragment) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder docBuilder = XPathUtil.getBuilder();
        Document doc = parent.getOwnerDocument();
        Node fragmentNode = docBuilder.parse(new InputSource(new StringReader(fragment))).getDocumentElement();
        fragmentNode = doc.importNode(fragmentNode, true);
        parent.appendChild(fragmentNode);
    }

    public static String getXml(Node node) {
        return XPathUtil.getXml(node, false, 0);
    }

    public static String getXml(Node node, boolean indentXml, int indentSize) {
        try {
            Transformer transformer;
            TransformerFactory tf = TransformerFactory.newInstance();
            if (indentXml) {
                transformer = tf.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", new Integer(indentSize).toString());
            } else {
                transformer = tf.newTransformer(new StreamSource(XPathUtil.class.getResourceAsStream("remove-whitespace.xsl")));
            }
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(node);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            return xmlString;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static XMLGregorianCalendar convertDateToXmlDate(Date date) {
        try {
            GregorianCalendar fromDate = new GregorianCalendar();
            fromDate.setTime(date);
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(fromDate);
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String lookupParameterValue(String key, String string) {
        Pattern p = Pattern.compile("\\[" + key + "=[^\\]]*\\]");
        Matcher m = p.matcher(string);
        m.find();
        String f = m.group();
        int p1 = f.indexOf(61);
        int p2 = f.indexOf(93);
        return f.substring(p1 + 1, p2);
    }

    public static String normalizeXmlString(String xml) {
        log.debug("XML from start:\n{}", (Object)xml);
        Document doc = XPathUtil.createDocument(xml);
        doc.setXmlStandalone(true);
        xml = XPathUtil.getXml(doc, false, 0);
        log.debug("XML after removing whitespace:\n{}", (Object)xml);
        doc = XPathUtil.createDocument(xml);
        doc.setXmlStandalone(true);
        xml = XPathUtil.getXml(doc, true, 2);
        log.debug("XML fully normalized:\n{}", (Object)xml);
        return xml;
    }

    private static class MapNamespaceContext
    implements NamespaceContext {
        private Map<String, String> namespaceMap;

        public MapNamespaceContext(Map<String, String> namespaceMap) {
            this.namespaceMap = namespaceMap;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.namespaceMap.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            String prefix = null;
            for (Map.Entry<String, String> entry : this.namespaceMap.entrySet()) {
                if (!entry.getValue().equals(namespaceURI)) continue;
                prefix = entry.getKey();
                break;
            }
            return prefix;
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

