/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.soap;

import java.text.MessageFormat;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.transformer.AbstractMessageTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSoapFaultIfExceptionTransformer
extends AbstractMessageTransformer {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    static String SOAP_FAULT_V11 = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">\n  <soapenv:Header/>  <soapenv:Body>    <soap:Fault xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n      <faultcode>soap:Server</faultcode>\n      <faultstring>{0}</faultstring>\n      <faultactor>{1}</faultactor>\n      <detail>\n        {2}\n      </detail>\n    </soap:Fault>  </soapenv:Body></soapenv:Envelope>";

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        this.logger.debug("transform() called");
        ExceptionPayload ep = message.getExceptionPayload();
        if (ep == null) {
            this.logger.debug("No error, return origin message");
            return message;
        }
        this.logger.debug("ExceptionPayload detected as well, let's create a SOAP-FAULT!");
        String soapFault = this.createSoapFaultFromExceptionPayload(ep);
        this.logger.debug("Created soapFault: {}", (Object)soapFault);
        this.logger.debug("Set ExceptionPayload to null and outbound http.status=500");
        message.setExceptionPayload(null);
        message.setProperty("http.status", (Object)500, PropertyScope.OUTBOUND);
        message.setPayload((Object)soapFault);
        return message;
    }

    protected String createSoapFaultFromExceptionPayload(ExceptionPayload ep) {
        this.logger.debug("Exception: " + ep.getException() + ", " + ep.getException().getClass().getName());
        this.logger.debug("RootException: " + ep.getRootException() + ", " + ep.getRootException().getClass().getName());
        Throwable e = ep.getRootException() != null ? ep.getRootException() : ep.getException();
        String errMsg = e.getMessage();
        String endpoint = this.getEndpoint().getEndpointURI().getAddress();
        String detail = e.getMessage();
        return this.createSoapFault(errMsg, endpoint, detail);
    }

    protected String createSoapFault(String errMsg, String endpoint, String details) {
        return MessageFormat.format(SOAP_FAULT_V11, errMsg, endpoint, details);
    }
}

