/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.mime;

import java.io.IOException;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.transformer.AbstractMessageTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.mule.core.ObjectToStringTransformer;
import org.soitoolkit.commons.mule.util.MiscUtil;

public class MimeToStringTransformer
extends AbstractMessageTransformer {
    private static final Logger log = LoggerFactory.getLogger(MimeToStringTransformer.class);
    private ObjectToStringTransformer o2s = new ObjectToStringTransformer();

    public MimeToStringTransformer() {
        this.registerSourceType(Object.class);
        this.setReturnClass(String.class);
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        Object payload = message.getPayload();
        String contentType = (String)message.getProperty("Content-Type", PropertyScope.INBOUND);
        if (contentType == null) {
            contentType = (String)message.getProperty("content-type", PropertyScope.INBOUND);
        }
        try {
            log.debug("Parsing contentType: {}", (Object)contentType);
            ContentType ct = new ContentType(contentType);
            String baseType = ct.getBaseType();
            String charset = ct.getParameter("charset");
            if (charset == null) {
                charset = "UTF-8";
            }
            log.debug("Parse results: baseType = {}, charset = {}", (Object)baseType, (Object)charset);
            if (baseType.equals("application/x-www-form-urlencoded")) {
                payload = message.getPropertyNames().iterator().next();
                log.info("Found payload of type x-www-form-urlencoded");
            } else if (baseType.equals("multipart/form-data")) {
                payload = this.transformMultipartPayload(payload, contentType);
                log.info("Found payload of type multipart/form-data payload");
            } else if (baseType.equals("text/xml")) {
                payload = MiscUtil.convertStreamToString((InputStream)payload, charset);
                log.info("Found payload of type text/xml");
            } else if (baseType.equals("application/octet-stream")) {
                payload = MiscUtil.convertStreamToString((InputStream)payload, charset);
                log.info("Found payload of type application/octet-stream: {}", payload);
            } else {
                log.warn("*** UNKNOWN CONTENT-TYPE FOUND: {}, PAYLOAD-TYPE: {}", (Object)contentType, (Object)payload.getClass().getName());
                payload = this.o2s.transform(payload, outputEncoding);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            log.warn("*** UNKNOWN CONTENT-TYPE FOUND: {}, PAYLOAD-TYPE: {}", (Object)contentType, (Object)payload.getClass().getName());
            payload = this.o2s.transform(payload, outputEncoding);
        }
        log.debug("Returning: {}", payload);
        return payload;
    }

    private Object transformMultipartPayload(Object payload, String contentType) {
        if (payload instanceof InputStream) {
            try {
                Object content;
                MimeMessage mm = new MimeMessage(null, (InputStream)payload);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("MIME Content typ = " + mm.getContentType()));
                }
                if ((content = mm.getContent()) instanceof String) {
                    payload = this.removeTrailingMimeBoundary(contentType, (String)content);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"*** Plain text FOUND");
                    }
                } else if (content instanceof MimeMultipart) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"*** MULTI-PART CONTENT FOUND");
                    }
                    MimeMultipart multipart = (MimeMultipart)mm.getContent();
                    InputStream cont = (InputStream)multipart.getBodyPart(0).getContent();
                    payload = MiscUtil.convertStreamToString(cont);
                } else if (content instanceof InputStream) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"*** INPUT-STREAM CONTENT FOUND");
                    }
                    String str = MiscUtil.convertStreamToString((InputStream)content);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("*** INPUT-STREAM CONTENT = " + str));
                    }
                    payload = this.removeTrailingMimeBoundary(contentType, str);
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"*** UNKNOWN CONTENT FOUND");
                    }
                    payload = content.toString();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("*** MULTI-PART PAYLOAD TYPE = " + payload.getClass().getName()));
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("*** MULTI-PART PAYLOAD LENGTH = " + payload.toString().length()));
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("*** MULTI-PART PAYLOAD = " + payload));
                }
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return payload;
    }

    private String removeTrailingMimeBoundary(String contentType, String str) {
        int boundaryStartPos = contentType.indexOf("boundary=");
        String boundary = contentType.substring(boundaryStartPos + "boundary=".length());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("*** BOUNDARY = " + boundary));
        }
        boundaryStartPos = str.indexOf("--" + boundary + "--");
        String payload = ((Object)str.subSequence(0, --boundaryStartPos)).toString();
        return payload;
    }
}

