/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.test.sftp;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyPair;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String keygenDirPath = "target/ssh";
    private String passphrase = "testonly";

    public static void main(String[] args) {
        new KeyGenerator().generateKeys();
    }

    public void setKeygenDirPath(String keygenDirPath) {
        this.keygenDirPath = keygenDirPath;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public void generateKeys() {
        try {
            String keyFilename = this.keygenDirPath + File.separatorChar + "id_dsa";
            String keyComment = "soitoolkit test key, embedded use only";
            File privateKeyFile = new File(keyFilename);
            if (privateKeyFile.exists()) {
                this.logger.debug("keyfile exists, will not create new key: {}", (Object)privateKeyFile);
                return;
            }
            File dirs = new File(this.keygenDirPath);
            if (!dirs.exists() && !dirs.mkdirs()) {
                throw new IOException("could not create dir(s): " + this.keygenDirPath);
            }
            this.logger.debug("generating keys in dir: {}", (Object)dirs);
            JSch jsch = new JSch();
            KeyPair kpair = KeyPair.genKeyPair((JSch)jsch, (int)1);
            kpair.setPassphrase(this.passphrase);
            kpair.writePrivateKey(keyFilename);
            kpair.writePublicKey(keyFilename + ".pub", keyComment);
            kpair.dispose();
        }
        catch (Exception e) {
            String errMsg = "Failed to generate SSH keys";
            this.logger.error(errMsg, (Throwable)e);
            throw new RuntimeException(errMsg, e);
        }
    }
}

