/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring.properties;

import org.jasypt.commons.CommonUtils;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.properties.PropertyValueEncryptionUtils;
import org.jasypt.util.text.TextEncryptor;
import org.springframework.beans.factory.config.PropertyOverrideConfigurer;

public final class EncryptablePropertyOverrideConfigurer
extends PropertyOverrideConfigurer {
    private final StringEncryptor stringEncryptor;
    private final TextEncryptor textEncryptor;

    public EncryptablePropertyOverrideConfigurer(StringEncryptor stringEncryptor) {
        CommonUtils.validateNotNull(stringEncryptor, "Encryptor cannot be null");
        this.stringEncryptor = stringEncryptor;
        this.textEncryptor = null;
    }

    public EncryptablePropertyOverrideConfigurer(TextEncryptor textEncryptor) {
        CommonUtils.validateNotNull(textEncryptor, "Encryptor cannot be null");
        this.stringEncryptor = null;
        this.textEncryptor = textEncryptor;
    }

    protected String convertPropertyValue(String originalValue) {
        if (!PropertyValueEncryptionUtils.isEncryptedValue(originalValue)) {
            return originalValue;
        }
        if (this.stringEncryptor != null) {
            return PropertyValueEncryptionUtils.decrypt(originalValue, this.stringEncryptor);
        }
        return PropertyValueEncryptionUtils.decrypt(originalValue, this.textEncryptor);
    }
}

