/*
 * Decompiled with CFR 0.152.
 */
package org.soitoolkit.commons.mule.ftp;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.ftp.FtpConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soitoolkit.commons.mule.util.MuleUtil;

public class FtpUtil {
    private static final Logger logger = LoggerFactory.getLogger(FtpUtil.class);
    public static final int FTP_FILE_NOT_FOUND = 550;
    public static final int FTP_PATH_CREATED = 257;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initEndpointDirectory(MuleContext muleContext, String endpointName) throws Exception {
        logger.info("Init directory for endpoint: {}", (Object)endpointName);
        FTPClient ftpClient = null;
        try {
            ftpClient = FtpUtil.getFtpClient(muleContext, endpointName);
            EndpointURI endpointURI = MuleUtil.getImmutableEndpoint(muleContext, endpointName).getEndpointURI();
            String path = endpointURI.getPath();
            try {
                if (path.startsWith("/~/")) {
                    path = path.substring(3);
                } else if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                FtpUtil.recursiveDeleteDirectory(ftpClient, path);
                FtpUtil.recursiveCreateDirectory(ftpClient, path);
            }
            catch (IOException e) {
                if (logger.isErrorEnabled()) {
                    logger.error("Failed to recursivly delete endpoint " + endpointName, (Throwable)e);
                }
            }
        }
        finally {
            if (ftpClient != null) {
                ftpClient.disconnect();
            }
        }
    }

    public static void recursiveDeleteDirectory(FTPClient ftpClient, String path) throws IOException {
        logger.info("Delete directory: {}", (Object)path);
        FTPFile[] ftpFiles = ftpClient.listFiles(path);
        logger.debug("Number of files that will be deleted: {}", (Object)ftpFiles.length);
        for (FTPFile ftpFile : ftpFiles) {
            String filename = path + "/" + ftpFile.getName();
            if (ftpFile.getType() == 0) {
                boolean deleted = ftpClient.deleteFile(filename);
                logger.debug("Deleted {}? {}", (Object)filename, (Object)deleted);
                continue;
            }
            FtpUtil.recursiveDeleteDirectory(ftpClient, filename);
        }
        boolean dirDeleted = ftpClient.deleteFile(path);
        logger.debug("Directory {} deleted: {}", (Object)path, (Object)dirDeleted);
    }

    public static void recursiveCreateDirectory(FTPClient ftpClient, String path) throws IOException {
        int sepIdx;
        logger.info("Create Directory: {}", (Object)path);
        int createDirectoryStatus = ftpClient.mkd(path);
        logger.debug("Create Directory Status: {}", (Object)createDirectoryStatus);
        if (createDirectoryStatus == 550 && (sepIdx = path.lastIndexOf(47)) > -1) {
            String parentPath = path.substring(0, sepIdx);
            FtpUtil.recursiveCreateDirectory(ftpClient, parentPath);
            logger.debug("2'nd CreateD irectory: {}", (Object)path);
            createDirectoryStatus = ftpClient.mkd(path);
            logger.debug("2'nd Create Directory Status: {}", (Object)createDirectoryStatus);
        }
    }

    private static FTPClient getFtpClient(MuleContext muleContext, String endpointName) throws Exception {
        ImmutableEndpoint endpoint = MuleUtil.getImmutableEndpoint(muleContext, endpointName);
        FtpConnector c = (FtpConnector)endpoint.getConnector();
        return c.getFtp(endpoint.getEndpointURI());
    }
}

