/*
 * Decompiled with CFR 0.152.
 */
package org.opensrp.api.util;

import java.util.HashMap;
import java.util.Map;

public class TreeNode<K, T> {
    private K id;
    private String label;
    private T node;
    private Map<K, TreeNode<K, T>> children;
    private K parent;

    public TreeNode(K id, String label, T node, K parent) {
        this.id = id;
        this.label = label;
        this.node = node;
        this.parent = parent;
    }

    public TreeNode(K id, String label, T node, K parent, Map<K, TreeNode<K, T>> children) {
        this.id = id;
        this.label = label;
        this.node = node;
        this.parent = parent;
        this.children = children;
    }

    public void addChild(TreeNode<K, T> node) {
        if (this.children == null) {
            this.children = new HashMap<K, TreeNode<K, T>>();
        }
        this.children.put(node.getId(), node);
    }

    public TreeNode<K, T> findChild(K id) {
        if (this.children != null) {
            for (TreeNode<K, T> child : this.children.values()) {
                TreeNode<K, T> node;
                if (child.getId().equals(id)) {
                    return child;
                }
                if (child.getChildren() == null || (node = child.findChild(id)) == null) continue;
                return node;
            }
        }
        return null;
    }

    public TreeNode<K, T> removeChild(K id) {
        if (this.children != null) {
            for (TreeNode<K, T> child : this.children.values()) {
                TreeNode<K, T> node;
                if (child.getId().equals(id)) {
                    return this.children.remove(id);
                }
                if (child.getChildren() == null || (node = child.removeChild(id)) == null) continue;
                return node;
            }
        }
        return null;
    }

    public K getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public T getNode() {
        return this.node;
    }

    public K getParent() {
        return this.parent;
    }

    public Map<K, TreeNode<K, T>> getChildren() {
        return this.children;
    }

    void setLabel(String label) {
        this.label = label;
    }

    void setNode(T node) {
        this.node = node;
    }

    void setParent(K parent) {
        this.parent = parent;
    }
}

