/*
 * Decompiled with CFR 0.152.
 */
package org.opensrp.api.domain;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.opensrp.api.domain.Address;
import org.opensrp.api.domain.BaseDataObject;

public class Location
extends BaseDataObject {
    private String locationId;
    private String name;
    private Address address;
    private Map<String, String> identifiers;
    private Location parentLocation;
    private Set<String> tags;
    private Map<String, Object> attributes;

    public Location() {
    }

    public Location(String locationId, String name, Address address, Location parentLocation) {
        this.locationId = locationId;
        this.name = name;
        this.address = address;
        this.parentLocation = parentLocation;
    }

    public Location(String locationId, String name, Address address, Map<String, String> identifiers, Location parentLocation, Set<String> tags, Map<String, Object> attributes) {
        this.locationId = locationId;
        this.name = name;
        this.address = address;
        this.identifiers = identifiers;
        this.parentLocation = parentLocation;
        this.tags = tags;
        this.attributes = attributes;
    }

    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Map<String, String> getIdentifiers() {
        return this.identifiers;
    }

    public String getIdentifier(String identifierType) {
        return this.identifiers.get(identifierType);
    }

    public void setIdentifiers(Map<String, String> identifiers) {
        this.identifiers = identifiers;
    }

    public void addIdentifier(String identifierType, String identifier) {
        if (this.identifiers == null) {
            this.identifiers = new HashMap<String, String>();
        }
        this.identifiers.put(identifierType, identifier);
    }

    public void removeIdentifier(String identifierType) {
        this.identifiers.remove(identifierType);
    }

    public Location getParentLocation() {
        return this.parentLocation;
    }

    public void setParentLocation(Location parentLocation) {
        this.parentLocation = parentLocation;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public void addTag(String tag) {
        if (this.tags == null) {
            this.tags = new HashSet<String>();
        }
        this.tags.add(tag);
    }

    public boolean removeTag(String tag) {
        return this.tags.remove(tag);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Location withLocationId(String locationId) {
        this.locationId = locationId;
        return this;
    }

    public Location withName(String name) {
        this.name = name;
        return this;
    }

    public Location withAddress(Address address) {
        this.address = address;
        return this;
    }

    public Location withIdentifiers(Map<String, String> identifiers) {
        this.identifiers = identifiers;
        return this;
    }

    public Location withIdentifier(String identifierType, String identifier) {
        if (this.identifiers == null) {
            this.identifiers = new HashMap<String, String>();
        }
        this.identifiers.put(identifierType, identifier);
        return this;
    }

    public Location withParentLocation(Location parentLocation) {
        this.parentLocation = parentLocation;
        return this;
    }

    public Location withTags(Set<String> tags) {
        this.tags = tags;
        return this;
    }

    public Location withTag(String tag) {
        if (this.tags == null) {
            this.tags = new HashSet<String>();
        }
        this.tags.add(tag);
        return this;
    }

    public Location withAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public Location withAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

