/*
 * Decompiled with CFR 0.152.
 */
package org.opensrp.api.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.opensrp.api.domain.Address;
import org.opensrp.api.domain.BaseDataObject;

public class BaseEntity
extends BaseDataObject {
    private String baseEntityId;
    private Map<String, String> identifiers;
    private List<Address> addresses;
    private Map<String, Object> attributes;

    protected BaseEntity() {
    }

    public BaseEntity(String baseEntityId) {
        this.baseEntityId = baseEntityId;
    }

    public BaseEntity(String baseEntityId, Map<String, String> identifiers) {
        this.baseEntityId = baseEntityId;
        this.identifiers = identifiers;
    }

    public BaseEntity(String baseEntityId, Map<String, String> identifiers, Map<String, Object> attributes) {
        this.baseEntityId = baseEntityId;
        this.identifiers = identifiers;
        this.attributes = attributes;
    }

    public BaseEntity(String baseEntityId, Map<String, String> identifiers, Map<String, Object> attributes, List<Address> addresses) {
        this.baseEntityId = baseEntityId;
        this.identifiers = identifiers;
        this.attributes = attributes;
        this.addresses = addresses;
    }

    public String getBaseEntityId() {
        return this.baseEntityId;
    }

    public void setBaseEntityId(String baseEntityId) {
        this.baseEntityId = baseEntityId;
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public void addAddress(Address address) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Address>();
        }
        this.addresses.add(address);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        for (String k : this.attributes.keySet()) {
            if (!k.equalsIgnoreCase(name)) continue;
            return this.attributes.get(k);
        }
        return null;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Map<String, String> getIdentifiers() {
        return this.identifiers;
    }

    public String getIdentifier(String identifierType) {
        if (this.identifiers == null) {
            return null;
        }
        for (String k : this.identifiers.keySet()) {
            if (!k.equalsIgnoreCase(identifierType)) continue;
            return this.identifiers.get(k);
        }
        return null;
    }

    public String getIdentifierMatchingRegex(String regex) {
        for (Map.Entry<String, String> a : this.getIdentifiers().entrySet()) {
            if (!a.getKey().matches(regex)) continue;
            return a.getValue();
        }
        return null;
    }

    public void setIdentifiers(Map<String, String> identifiers) {
        this.identifiers = identifiers;
    }

    public void addIdentifier(String identifierType, String identifier) {
        if (this.identifiers == null) {
            this.identifiers = new HashMap<String, String>();
        }
        this.identifiers.put(identifierType, identifier);
    }

    public void removeIdentifier(String identifierType) {
        this.identifiers.remove(identifierType);
    }

    public BaseEntity withBaseEntityId(String baseEntityId) {
        this.baseEntityId = baseEntityId;
        return this;
    }

    public BaseEntity withIdentifiers(Map<String, String> identifiers) {
        this.identifiers = identifiers;
        return this;
    }

    public BaseEntity withIdentifier(String identifierType, String identifier) {
        if (this.identifiers == null) {
            this.identifiers = new HashMap<String, String>();
        }
        this.identifiers.put(identifierType, identifier);
        return this;
    }

    public BaseEntity withAddresses(List<Address> addresses) {
        this.addresses = addresses;
        return this;
    }

    public BaseEntity withAddress(Address address) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Address>();
        }
        this.addresses.add(address);
        return this;
    }

    public BaseEntity withAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public BaseEntity withAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

