/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.util.MethodUtil;
import org.jf.dexlib2.writer.ProtoSection;
import org.jf.dexlib2.writer.builder.BuilderContext;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;
import org.jf.dexlib2.writer.builder.BuilderProtoReference;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypeList;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.jf.util.CharSequenceUtils;

class BuilderProtoPool
implements ProtoSection<BuilderStringReference, BuilderTypeReference, BuilderProtoReference, BuilderTypeList> {
    @Nonnull
    private final BuilderContext context;
    @Nonnull
    private final ConcurrentMap<ProtoKey, BuilderProtoReference> internedItems = Maps.newConcurrentMap();

    BuilderProtoPool(@Nonnull BuilderContext context) {
        this.context = context;
    }

    @Nonnull
    public BuilderProtoReference internProto(@Nonnull List<? extends CharSequence> parameters, @Nonnull String returnType) {
        Key key = new Key(parameters, returnType);
        BuilderProtoReference ret = (BuilderProtoReference)this.internedItems.get(key);
        if (ret != null) {
            return ret;
        }
        BuilderProtoReference protoReference = new BuilderProtoReference(this.context.stringPool.internString(MethodUtil.getShorty(parameters, returnType)), this.context.typeListPool.internTypeList(parameters), this.context.typePool.internType(returnType));
        ret = this.internedItems.putIfAbsent(protoReference, protoReference);
        return ret == null ? protoReference : ret;
    }

    @Nonnull
    public BuilderProtoReference internProto(@Nonnull MethodReference methodReference) {
        return this.internProto(methodReference.getParameterTypes(), methodReference.getReturnType());
    }

    @Override
    @Nonnull
    public BuilderStringReference getShorty(@Nonnull BuilderProtoReference key) {
        return key.shorty;
    }

    @Override
    @Nonnull
    public BuilderTypeReference getReturnType(@Nonnull BuilderProtoReference key) {
        return key.returnType;
    }

    @Override
    @Nullable
    public BuilderTypeList getParameters(@Nonnull BuilderProtoReference key) {
        return key.parameterTypes;
    }

    @Override
    public int getItemIndex(@Nonnull BuilderProtoReference key) {
        return key.index;
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends BuilderProtoReference, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderProtoReference>(this.internedItems.values()){

            @Override
            protected int getValue(@Nonnull BuilderProtoReference key) {
                return key.index;
            }

            @Override
            protected int setValue(@Nonnull BuilderProtoReference key, int value) {
                int prev = key.index;
                key.index = value;
                return prev;
            }
        };
    }

    private static class Key
    implements ProtoKey {
        @Nonnull
        private final List<? extends CharSequence> parameters;
        @Nonnull
        private final String returnType;

        public Key(@Nonnull List<? extends CharSequence> parameters, @Nonnull String returnType) {
            this.parameters = parameters;
            this.returnType = returnType;
        }

        @Override
        @Nonnull
        public List<? extends CharSequence> getParameterTypes() {
            return this.parameters;
        }

        @Override
        @Nonnull
        public String getReturnType() {
            return this.returnType;
        }

        public int hashCode() {
            int hashCode = this.returnType.hashCode();
            return hashCode * 31 + this.parameters.hashCode();
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof ProtoKey) {
                ProtoKey other = (ProtoKey)o;
                return this.getReturnType().equals(other.getReturnType()) && CharSequenceUtils.listEquals(this.getParameterTypes(), other.getParameterTypes());
            }
            return false;
        }
    }

    static interface ProtoKey {
        @Nonnull
        public List<? extends CharSequence> getParameterTypes();

        @Nonnull
        public String getReturnType();
    }
}

