/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.dexbacked.raw.AnnotationSetItem;
import org.jf.dexlib2.dexbacked.raw.AnnotationSetRefList;
import org.jf.dexlib2.dexbacked.raw.FieldIdItem;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.MethodIdItem;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class AnnotationDirectoryItem {
    public static final int CLASS_ANNOTATIONS_OFFSET = 0;
    public static final int FIELD_SIZE_OFFSET = 4;
    public static final int ANNOTATED_METHOD_SIZE_OFFSET = 8;
    public static final int ANNOTATED_PARAMETERS_SIZE = 12;

    @Nonnull
    public static SectionAnnotator makeAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            @Nonnull
            public String getItemName() {
                return "annotation_directory_item";
            }

            @Override
            public int getItemAlignment() {
                return 4;
            }

            @Override
            protected void annotateItem(@Nonnull AnnotatedBytes out, int itemIndex, @Nullable String itemIdentity) {
                int methodIndex;
                int annotationOffset;
                int i;
                int classAnnotationsOffset = this.dexFile.readSmallUint(out.getCursor());
                out.annotate(4, "class_annotations_off = %s", AnnotationSetItem.getReferenceAnnotation(this.dexFile, classAnnotationsOffset));
                int fieldsSize = this.dexFile.readSmallUint(out.getCursor());
                out.annotate(4, "fields_size = %d", fieldsSize);
                int annotatedMethodsSize = this.dexFile.readSmallUint(out.getCursor());
                out.annotate(4, "annotated_methods_size = %d", annotatedMethodsSize);
                int annotatedParameterSize = this.dexFile.readSmallUint(out.getCursor());
                out.annotate(4, "annotated_parameters_size = %d", annotatedParameterSize);
                if (fieldsSize > 0) {
                    out.annotate(0, "field_annotations:", new Object[0]);
                    out.indent();
                    for (i = 0; i < fieldsSize; ++i) {
                        out.annotate(0, "field_annotation[%d]", i);
                        out.indent();
                        int fieldIndex = this.dexFile.readSmallUint(out.getCursor());
                        out.annotate(4, "%s", FieldIdItem.getReferenceAnnotation(this.dexFile, fieldIndex));
                        annotationOffset = this.dexFile.readSmallUint(out.getCursor());
                        out.annotate(4, "%s", AnnotationSetItem.getReferenceAnnotation(this.dexFile, annotationOffset));
                        out.deindent();
                    }
                    out.deindent();
                }
                if (annotatedMethodsSize > 0) {
                    out.annotate(0, "method_annotations:", new Object[0]);
                    out.indent();
                    for (i = 0; i < annotatedMethodsSize; ++i) {
                        out.annotate(0, "method_annotation[%d]", i);
                        out.indent();
                        methodIndex = this.dexFile.readSmallUint(out.getCursor());
                        out.annotate(4, "%s", MethodIdItem.getReferenceAnnotation(this.dexFile, methodIndex));
                        annotationOffset = this.dexFile.readSmallUint(out.getCursor());
                        out.annotate(4, "%s", AnnotationSetItem.getReferenceAnnotation(this.dexFile, annotationOffset));
                        out.deindent();
                    }
                    out.deindent();
                }
                if (annotatedParameterSize > 0) {
                    out.annotate(0, "parameter_annotations:", new Object[0]);
                    out.indent();
                    for (i = 0; i < annotatedParameterSize; ++i) {
                        out.annotate(0, "parameter_annotation[%d]", i);
                        out.indent();
                        methodIndex = this.dexFile.readSmallUint(out.getCursor());
                        out.annotate(4, "%s", MethodIdItem.getReferenceAnnotation(this.dexFile, methodIndex));
                        annotationOffset = this.dexFile.readSmallUint(out.getCursor());
                        out.annotate(4, "%s", AnnotationSetRefList.getReferenceAnnotation(this.dexFile, annotationOffset));
                        out.deindent();
                    }
                    out.deindent();
                }
            }
        };
    }
}

