/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.jsonassert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.JSONParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONCompare {
    public static JSONCompareResult compareJSON(String expectedStr, String actualStr, JSONCompareMode mode) throws JSONException {
        Object expected = JSONParser.parseJSON(expectedStr);
        Object actual = JSONParser.parseJSON(actualStr);
        if (expected instanceof JSONObject && actual instanceof JSONObject) {
            return JSONCompare.compareJSON((JSONObject)expected, (JSONObject)actual, mode);
        }
        if (expected instanceof JSONArray && actual instanceof JSONArray) {
            return JSONCompare.compareJSON((JSONArray)expected, (JSONArray)actual, mode);
        }
        if (expected instanceof JSONObject) {
            throw new IllegalArgumentException("Expected a JSON object, but passed in a JSON array.");
        }
        throw new IllegalArgumentException("Expected a JSON array, but passed in a JSON object.");
    }

    public static JSONCompareResult compareJSON(JSONObject expected, JSONObject actual, JSONCompareMode mode) throws JSONException {
        JSONCompareResult result = new JSONCompareResult();
        JSONCompare.compareJSON("", expected, actual, mode, result);
        return result;
    }

    public static JSONCompareResult compareJSON(JSONArray expected, JSONArray actual, JSONCompareMode mode) throws JSONException {
        JSONCompareResult result = new JSONCompareResult();
        JSONCompare.compareJSONArray("", expected, actual, mode, result);
        return result;
    }

    private static void compareJSON(String prefix, JSONObject expected, JSONObject actual, JSONCompareMode mode, JSONCompareResult result) throws JSONException {
        Set<String> expectedKeys = JSONCompare.getKeys(expected);
        for (String key : expectedKeys) {
            Object expectedValue = expected.get(key);
            if (actual.has(key)) {
                Object actualValue = actual.get(key);
                String fullKey = prefix + key;
                JSONCompare.compareValues(fullKey, expectedValue, actualValue, mode, result);
                continue;
            }
            result.fail("Does not contain expected key: " + prefix + key);
        }
        if (!mode.isExtensible()) {
            Set<String> actualKeys = JSONCompare.getKeys(actual);
            for (String key : actualKeys) {
                if (expected.has(key)) continue;
                result.fail("Strict checking failed.  Got but did not expect: " + prefix + key);
            }
        }
    }

    private static void compareValues(String fullKey, Object expectedValue, Object actualValue, JSONCompareMode mode, JSONCompareResult result) throws JSONException {
        if (expectedValue.getClass().isAssignableFrom(actualValue.getClass())) {
            if (expectedValue instanceof JSONArray) {
                JSONCompare.compareJSONArray(fullKey, (JSONArray)expectedValue, (JSONArray)actualValue, mode, result);
            } else if (expectedValue instanceof JSONObject) {
                JSONCompare.compareJSON(fullKey + ".", (JSONObject)expectedValue, (JSONObject)actualValue, mode, result);
            } else if (!expectedValue.equals(actualValue)) {
                result.fail(fullKey, expectedValue, actualValue);
            }
        }
    }

    private static void compareJSONArray(String key, JSONArray expected, JSONArray actual, JSONCompareMode mode, JSONCompareResult result) throws JSONException {
        if (expected.length() != actual.length()) {
            result.fail(key + "[]: Expected " + expected.length() + " values and got " + actual.length());
            return;
        }
        if (expected.length() == 0) {
            return;
        }
        if (mode.hasStrictOrder()) {
            for (int i = 0; i < expected.length(); ++i) {
                Object expectedValue = expected.get(i);
                Object actualValue = actual.get(i);
                JSONCompare.compareValues(key + "[" + i + "]", expectedValue, actualValue, mode, result);
            }
        } else if (JSONCompare.allSimpleValues(expected)) {
            Map expectedCount = CollectionUtils.getCardinalityMap(JSONCompare.jsonArrayToList(expected));
            Map actualCount = CollectionUtils.getCardinalityMap(JSONCompare.jsonArrayToList(actual));
            for (Object o : expectedCount.keySet()) {
                if (!actualCount.containsKey(o)) {
                    result.fail(key + "[]: Expected " + o + ", but not found");
                    continue;
                }
                if (actualCount.get(o) == expectedCount.get(o)) continue;
                result.fail(key + "[]: Expected contains " + expectedCount.get(o) + " " + o + " actual contains " + actualCount.get(o));
            }
            for (Object o : actualCount.keySet()) {
                if (expectedCount.containsKey(o)) continue;
                result.fail(key + "[]: Contains " + o + ", but not expected");
            }
        } else if (JSONCompare.allJSONObjects(expected)) {
            String uniqueKey = JSONCompare.findUniqueKey(expected);
            if (uniqueKey == null) {
                JSONCompare.recursivelyCompareJSONArray(key, expected, actual, mode, result);
                return;
            }
            Map<Object, JSONObject> expectedValueMap = JSONCompare.arrayOfJsonObjectToMap(expected, uniqueKey);
            Map<Object, JSONObject> actualValueMap = JSONCompare.arrayOfJsonObjectToMap(actual, uniqueKey);
            for (Object id : expectedValueMap.keySet()) {
                if (!actualValueMap.containsKey(id)) {
                    result.fail(key + "[]: Expected but did not find object where " + uniqueKey + "=" + id);
                    continue;
                }
                JSONObject expectedValue = expectedValueMap.get(id);
                JSONObject actualValue = actualValueMap.get(id);
                JSONCompare.compareValues(key + "[" + uniqueKey + "=" + id + "]", expectedValue, actualValue, mode, result);
            }
            for (Object id : actualValueMap.keySet()) {
                if (expectedValueMap.containsKey(id)) continue;
                result.fail(key + "[]: Contains object where \" + uniqueKey + \"=\" + id + \", but not expected");
            }
        } else {
            if (JSONCompare.allJSONArrays(expected)) {
                JSONCompare.recursivelyCompareJSONArray(key, expected, actual, mode, result);
                return;
            }
            JSONCompare.recursivelyCompareJSONArray(key, expected, actual, mode, result);
            return;
        }
    }

    private static void recursivelyCompareJSONArray(String key, JSONArray expected, JSONArray actual, JSONCompareMode mode, JSONCompareResult result) throws JSONException {
        HashSet<Integer> matched = new HashSet<Integer>();
        for (int i = 0; i < actual.length(); ++i) {
            Object actualElement = actual.get(i);
            boolean matchFound = false;
            for (int j = 0; j < expected.length(); ++j) {
                if (matched.contains(j) || !actual.get(i).getClass().equals(expected.get(j).getClass())) continue;
                if (actualElement instanceof JSONObject) {
                    if (!JSONCompare.compareJSON((JSONObject)actualElement, (JSONObject)expected.get(j), mode).passed()) continue;
                    matched.add(j);
                    matchFound = true;
                    break;
                }
                if (actualElement instanceof JSONArray) {
                    if (!JSONCompare.compareJSON((JSONArray)actualElement, (JSONArray)expected.get(j), mode).passed()) continue;
                    matched.add(j);
                    matchFound = true;
                    break;
                }
                if (!actualElement.equals(expected.get(j))) continue;
                matched.add(j);
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            result.fail("Could not find match for element " + actualElement);
            return;
        }
    }

    private static Map<Object, JSONObject> arrayOfJsonObjectToMap(JSONArray array, String uniqueKey) throws JSONException {
        HashMap<Object, JSONObject> valueMap = new HashMap<Object, JSONObject>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject jsonObject = (JSONObject)array.get(i);
            Object id = jsonObject.get(uniqueKey);
            valueMap.put(id, jsonObject);
        }
        return valueMap;
    }

    private static String findUniqueKey(JSONArray expected) throws JSONException {
        JSONObject o = (JSONObject)expected.get(0);
        for (String candidate : JSONCompare.getKeys(o)) {
            Object candidateValue = o.get(candidate);
            if (!JSONCompare.isSimpleValue(candidateValue)) continue;
            HashSet<Object> seenValues = new HashSet<Object>();
            seenValues.add(candidateValue);
            boolean isUsableKey = true;
            for (int i = 1; i < expected.length(); ++i) {
                JSONObject other = (JSONObject)expected.get(i);
                if (!other.has(candidate)) {
                    isUsableKey = false;
                    break;
                }
                Object comparisonValue = other.get(candidate);
                if (!JSONCompare.isSimpleValue(comparisonValue) || seenValues.contains(comparisonValue)) {
                    isUsableKey = false;
                    break;
                }
                seenValues.add(comparisonValue);
            }
            if (!isUsableKey) continue;
            return candidate;
        }
        return null;
    }

    private static List<Object> jsonArrayToList(JSONArray expected) throws JSONException {
        ArrayList<Object> jsonObjects = new ArrayList<Object>(expected.length());
        for (int i = 0; i < expected.length(); ++i) {
            jsonObjects.add(expected.get(i));
        }
        return jsonObjects;
    }

    private static boolean allSimpleValues(JSONArray array) throws JSONException {
        for (int i = 0; i < array.length(); ++i) {
            if (JSONCompare.isSimpleValue(array.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSimpleValue(Object o) {
        return !(o instanceof JSONObject) && !(o instanceof JSONArray);
    }

    private static boolean allJSONObjects(JSONArray array) throws JSONException {
        for (int i = 0; i < array.length(); ++i) {
            if (array.get(i) instanceof JSONObject) continue;
            return false;
        }
        return true;
    }

    private static boolean allJSONArrays(JSONArray array) throws JSONException {
        for (int i = 0; i < array.length(); ++i) {
            if (array.get(i) instanceof JSONArray) continue;
            return false;
        }
        return true;
    }

    private static Set<String> getKeys(JSONObject jsonObject) {
        TreeSet<String> keys = new TreeSet<String>();
        Iterator iter = jsonObject.keys();
        while (iter.hasNext()) {
            keys.add((String)iter.next());
        }
        return keys;
    }
}

