/*
 * Decompiled with CFR 0.152.
 */
package org.skife.waffles;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import net.e175.klaus.zip.ZipPrefixer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="really-executable-jar", threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class ReallyExecutableJarMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="really-executable-jar.inputFile")
    private File inputFile = null;
    @Parameter(property="really-executable-jar.flags")
    private String flags = "";
    @Parameter(property="really-executable-jar.programFile")
    private String programFile = null;
    @Parameter(property="really-executable-jar.classifier")
    private String classifier;
    @Parameter(defaultValue="false", property="really-executable-jar.allowOtherTypes")
    private boolean allowOtherTypes;
    @Parameter(defaultValue="false", property="really-executable-jar.attachProgramFile")
    private boolean attachProgramFile = false;
    @Parameter(defaultValue="sh", property="really-executable-jar.programFileType")
    private String programFileType = "sh";
    @Parameter(property="really-executable-jar.scriptFile")
    private String scriptFile = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        try {
            ArrayList<File> files = new ArrayList<File>();
            if (this.inputFile != null) {
                if (!this.inputFile.exists()) throw new MojoExecutionException("Unable to find " + this.inputFile);
                files.add(this.inputFile);
            } else {
                if (this.shouldProcess(this.project.getArtifact())) {
                    files.add(this.project.getArtifact().getFile());
                }
                for (Artifact item : this.project.getAttachedArtifacts()) {
                    if (!this.shouldProcess(item)) continue;
                    files.add(item.getFile());
                }
            }
            if (files.isEmpty()) {
                throw new MojoExecutionException("Could not find any jars to make executable");
            }
            if (this.programFile != null && !this.programFile.matches("\\s+")) {
                if (files.size() > 1) {
                    throw new MojoExecutionException("programFile set, but multiple candidate artifacts found: " + files);
                }
                File file = (File)files.get(0);
                File dir = file.getParentFile();
                File exec = new File(dir, this.programFile);
                Files.copy(file.toPath(), exec.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.makeExecutable(exec);
                if (!this.attachProgramFile) return;
                this.projectHelper.attachArtifact(this.project, this.programFileType, exec);
                return;
            } else {
                for (File file : files) {
                    this.makeExecutable(file);
                }
            }
            return;
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private boolean shouldProcess(Artifact artifact) {
        this.getLog().debug((CharSequence)("Considering " + artifact));
        if (artifact == null) {
            return false;
        }
        if (!this.allowOtherTypes && !artifact.getType().equals("jar")) {
            return false;
        }
        return this.classifier == null || this.classifier.equals(artifact.getClassifier());
    }

    private void makeExecutable(File file) throws MojoExecutionException {
        assert (file != null);
        this.getLog().debug((CharSequence)("Making " + file.getAbsolutePath() + " executable"));
        Path target = file.toPath();
        try {
            ZipPrefixer.applyPrefixBytesToZip((Path)target, Arrays.asList(this.getPreamble(target.toUri()), "\n\n".getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Failed to apply prefix to JAR [%s]", file.getAbsolutePath()), (Exception)e);
        }
        if (!file.setExecutable(true, false)) {
            throw new MojoExecutionException(String.format("Could not make JAR [%s] executable", file.getAbsolutePath()));
        }
        this.getLog().info((CharSequence)String.format("Successfully made JAR [%s] executable", file.getAbsolutePath()));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] getPreamble(URI uri) throws MojoExecutionException {
        try {
            if (this.scriptFile == null) {
                return ("#!/bin/sh\n\nexec java " + this.flags + " -jar \"$0\" \"$@\"").getBytes(StandardCharsets.UTF_8);
            }
            if (Files.isReadable(Paths.get(this.scriptFile, new String[0]))) {
                return Files.readAllBytes(Paths.get(this.scriptFile, new String[0]));
            }
            try (URLClassLoader loader = new URLClassLoader(new URL[]{uri.toURL()}, null);){
                byte[] byArray;
                block16: {
                    InputStream scriptIn = loader.getResourceAsStream(this.scriptFile);
                    try {
                        if (scriptIn == null) {
                            throw new IOException("unable to load " + this.scriptFile);
                        }
                        byArray = IOUtil.toByteArray((InputStream)scriptIn);
                        if (scriptIn == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (scriptIn != null) {
                            try {
                                scriptIn.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    scriptIn.close();
                }
                return byArray;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to load preamble data", (Exception)e);
        }
    }
}

