/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.wt.plugin.maven;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="sample")
public class GetSampleMojo
extends AbstractMojo {
    @Parameter(defaultValue="https://raw.githubusercontent.com/sitoolkit/sit-wt-all/master/sit-wt-runtime/", property="sample.baseUrl")
    private URL baseUrl;
    @Parameter(defaultValue="${basedir}", property="sample.basedir")
    private File basedir;
    @Parameter(defaultValue="src/main/webapp/input.html,src/main/webapp/terms.html,src/main/webapp/done.html,src/main/webapp/bootstrap.min.css,testscript/ExcelTestScript.xlsx", property="sample.resources")
    private String resources;

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (String res : this.resources.split(",")) {
            try {
                URL resUrl = new URL(this.baseUrl + res);
                File resFile = new File(this.basedir, res);
                this.getLog().info((CharSequence)("downloading " + resUrl));
                FileUtils.copyURLToFile((URL)resUrl, (File)resFile);
                this.getLog().info((CharSequence)("downloaded " + resFile.getAbsolutePath()));
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
    }
}

