/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.utils.mail.dkim;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.simplejavamail.utils.mail.dkim.DkimAcceptanceException;
import org.simplejavamail.utils.mail.dkim.DkimException;
import org.simplejavamail.utils.mail.dkim.DkimSigningException;
import org.simplejavamail.utils.mail.dkim.KeyPairType;
import org.simplejavamail.utils.mail.dkim.SigningAlgorithm;

public final class DomainKey {
    private static final String DKIM_VERSION = "DKIM1";
    private static final String EMAIL_SERVICE_TYPE = "email";
    private final long timestamp = System.currentTimeMillis();
    private final Pattern granularity;
    private final KeyPairType keyPairType;
    private final PublicKey publicKey;
    private final Set<String> serviceTypes;
    private final Map<Character, String> tags;

    public DomainKey(Map<Character, String> tags) throws DkimException {
        this.tags = Collections.unmodifiableMap(tags);
        String dkimVersionTagValue = this.getTagValue('v', DKIM_VERSION);
        if (!DKIM_VERSION.equals(dkimVersionTagValue)) {
            throw new DkimException("Incompatible version v=" + this.getTagValue('v') + ".");
        }
        String granularityTagValue = this.getTagValue('g', "*");
        this.granularity = this.getGranularityPattern(granularityTagValue);
        String keyTypeTagValue = this.getTagValue('k', KeyPairType.RSA.getDkimNotation());
        this.keyPairType = this.getPublicKeyType(keyTypeTagValue);
        if (null == this.keyPairType) {
            throw new DkimException("Incompatible key type k=" + this.getTagValue('k') + ".");
        }
        this.keyPairType.initialize();
        String serviceTypesTagValue = this.getTagValue('s', "*");
        this.serviceTypes = this.getServiceTypes(serviceTypesTagValue);
        if (!this.serviceTypes.contains("*") && !this.serviceTypes.contains(EMAIL_SERVICE_TYPE)) {
            throw new DkimException("Incompatible service type s=" + this.getTagValue('s') + ".");
        }
        String privateKeyTagValue = this.getTagValue('p');
        this.publicKey = this.getPublicKey(privateKeyTagValue);
        if (null == privateKeyTagValue) {
            throw new DkimException("Incompatible public key p=" + this.getTagValue('p') + ".");
        }
    }

    private KeyPairType getPublicKeyType(String keyTypeTagValue) {
        for (KeyPairType keyPairType : KeyPairType.values()) {
            if (!keyPairType.getDkimNotation().equals(keyTypeTagValue)) continue;
            return keyPairType;
        }
        return null;
    }

    private Set<String> getServiceTypes(String serviceTypesTagValue) {
        HashSet<String> serviceTypes = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(serviceTypesTagValue, ":", false);
        while (tokenizer.hasMoreElements()) {
            serviceTypes.add(tokenizer.nextToken().trim());
        }
        return serviceTypes;
    }

    private String getTagValue(char tag) {
        return this.getTagValue(tag, null);
    }

    private String getTagValue(char tag, String fallback) {
        String tagValue = this.tags.get(Character.valueOf(tag));
        return null == tagValue ? fallback : tagValue;
    }

    private PublicKey getPublicKey(String publicKeyTagValue) throws DkimException {
        if (null != publicKeyTagValue) {
            switch (this.keyPairType) {
                case RSA: {
                    return this.getRsaPublicKey(publicKeyTagValue);
                }
                case ED25519: {
                    return this.getEd25519PublicKey(publicKeyTagValue);
                }
            }
            throw new DkimException("Unknown public key type " + (Object)((Object)this.keyPairType) + ".");
        }
        throw new DkimException("Missing public key value.");
    }

    private RSAPublicKey getRsaPublicKey(String publicKeyTagValue) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KeyPairType.RSA.getJavaNotation());
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKeyTagValue));
            return (RSAPublicKey)keyFactory.generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new DkimException("RSA algorithm not found by JVM");
        }
        catch (IllegalArgumentException e) {
            throw new DkimException("The public key " + publicKeyTagValue + " couldn't be read.", e);
        }
        catch (InvalidKeySpecException e) {
            throw new DkimException("The public key " + publicKeyTagValue + " couldn't be decoded.", e);
        }
    }

    private EdDSAPublicKey getEd25519PublicKey(String publicKeyTagValue) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KeyPairType.ED25519.getJavaNotation());
            EdDSAPublicKeySpec publicKeySpec = new EdDSAPublicKeySpec(Base64.getDecoder().decode(publicKeyTagValue), (EdDSAParameterSpec)EdDSANamedCurveTable.ED_25519_CURVE_SPEC);
            return (EdDSAPublicKey)keyFactory.generatePublic((KeySpec)publicKeySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new DkimException("Ed25519 algorithm not found by JVM");
        }
        catch (IllegalArgumentException e) {
            throw new DkimException("The public key " + publicKeyTagValue + " couldn't be read.", e);
        }
        catch (InvalidKeySpecException e) {
            throw new DkimException("The public key " + publicKeyTagValue + " couldn't be decoded.", e);
        }
    }

    private Pattern getGranularityPattern(String granularity) {
        StringTokenizer tokenizer = new StringTokenizer(granularity, "*", true);
        StringBuffer pattern = new StringBuffer();
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if ("*".equals(token)) {
                pattern.append(".*");
                continue;
            }
            pattern.append(Pattern.quote(token));
        }
        return Pattern.compile(pattern.toString());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Pattern getGranularity() {
        return this.granularity;
    }

    public Set<String> getServiceTypes() {
        return this.serviceTypes;
    }

    public KeyPairType getPublicKeyType() {
        return this.keyPairType;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public Map<Character, String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "DomainKey [timestamp=" + this.timestamp + ", tags=" + this.tags + "]";
    }

    public void check(String identity, PrivateKey privateKey) throws DkimSigningException {
        this.checkIdentity(identity);
        this.checkKeyCompatiblilty(privateKey);
    }

    private void checkIdentity(String identity) throws DkimAcceptanceException {
        String localPart;
        if (null != identity && !identity.contains("@")) {
            throw new DkimAcceptanceException("Invalid identity: " + identity);
        }
        String string = localPart = null == identity ? "" : identity.substring(0, identity.indexOf(64));
        if (!this.granularity.matcher(localPart).matches()) {
            throw new DkimAcceptanceException("Incompatible identity for granularity " + this.getTagValue('g') + ": " + identity);
        }
    }

    private void checkKeyCompatiblilty(PrivateKey privateKey) throws DkimSigningException {
        try {
            SigningAlgorithm signingAlgorithm = this.keyPairType.getDefaultSigningAlgorithm();
            Signature signingSignature = Signature.getInstance(signingAlgorithm.getJavaNotation());
            signingSignature.initSign(privateKey);
            signingSignature.update("01189998819991197253".getBytes(StandardCharsets.UTF_8));
            byte[] signatureBytes = signingSignature.sign();
            Signature verifyingSignature = Signature.getInstance(signingAlgorithm.getJavaNotation());
            verifyingSignature.initVerify(this.publicKey);
            verifyingSignature.update("01189998819991197253".getBytes(StandardCharsets.UTF_8));
            if (!verifyingSignature.verify(signatureBytes)) {
                throw new DkimAcceptanceException("Incompatible private and public key.");
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new DkimSigningException("Performing cryptography failed.", e);
        }
    }
}

