/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.internal.authenticatedsockssupport.socks5server.AnonymousSocks5Server;
import org.simplejavamail.api.mailer.config.EmailGovernance;
import org.simplejavamail.api.mailer.config.OperationalConfig;
import org.simplejavamail.converter.EmailConverter;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerHelper;
import org.simplejavamail.mailer.internal.AbstractProxyServerSyncingClosure;
import org.simplejavamail.mailer.internal.MailerException;
import org.simplejavamail.mailer.internal.util.SessionLogger;
import org.simplejavamail.mailer.internal.util.TransportRunner;

class SendMailClosure
extends AbstractProxyServerSyncingClosure {
    @NotNull
    private final OperationalConfig operationalConfig;
    @NotNull
    private final EmailGovernance emailGovernance;
    @NotNull
    private final Session session;
    @NotNull
    private final Email email;
    private final boolean asyncForLoggingPurpose;
    private final boolean transportModeLoggingOnly;

    SendMailClosure(@NotNull OperationalConfig operationalConfig, @NotNull EmailGovernance emailGovernance, @NotNull Session session, @NotNull Email email, @Nullable AnonymousSocks5Server proxyServer, boolean asyncForLoggingPurpose, boolean transportModeLoggingOnly, @NotNull AtomicInteger smtpConnectionCounter) {
        super(smtpConnectionCounter, proxyServer);
        this.operationalConfig = operationalConfig;
        this.emailGovernance = emailGovernance;
        this.session = session;
        this.email = email;
        this.asyncForLoggingPurpose = asyncForLoggingPurpose;
        this.transportModeLoggingOnly = transportModeLoggingOnly;
    }

    @Override
    public void executeClosure() {
        LOGGER.trace("sending email...");
        try {
            MimeMessage message = MimeMessageProducerHelper.produceMimeMessage(this.email, this.session, this.emailGovernance.getPkcs12ConfigForSmimeSigning());
            SessionLogger.logSession(this.session, this.asyncForLoggingPurpose, "mail");
            message.saveChanges();
            this.email.internalSetId(message.getMessageID());
            this.logEmail(message);
            if (this.transportModeLoggingOnly) {
                LOGGER.info("TRANSPORT_MODE_LOGGING_ONLY: skipping actual sending...");
            } else if (this.operationalConfig.getCustomMailer() != null) {
                this.operationalConfig.getCustomMailer().sendMessage(this.operationalConfig, this.session, this.email, message);
            } else {
                TransportRunner.sendMessage(this.operationalConfig.getClusterKey(), this.session, message, message.getAllRecipients());
            }
        }
        catch (UnsupportedEncodingException e) {
            this.handleException(e, "Failed to send email [%s], reason: Encoding not accepted");
        }
        catch (MessagingException e) {
            this.handleException((Exception)((Object)e), "Failed to send email [%s], reason: Third party error");
        }
        catch (Exception e) {
            this.handleException(e, "Failed to send email [%s], reason: Unknown error");
        }
    }

    private void handleException(Exception e, String errorMsg) {
        LOGGER.trace("Failed to send email {}\n{}", (Object)this.email.getId(), (Object)this.email);
        throw new MailerException(String.format(errorMsg, this.email.getId()), e);
    }

    private void logEmail(MimeMessage message) {
        if (this.transportModeLoggingOnly) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\n\nEmail: {}\n", (Object)this.email);
                LOGGER.info("\n\nMimeMessage: {}\n", (Object)EmailConverter.mimeMessageToEML(message));
            }
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("\t\nEmail: {}", (Object)this.email);
            LOGGER.trace("\t\nMimeMessage: {}\n", (Object)EmailConverter.mimeMessageToEML(message));
        }
    }
}

