/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.mailer.Mailer;
import org.simplejavamail.api.mailer.MailerRegularBuilder;
import org.simplejavamail.api.mailer.config.ServerConfig;
import org.simplejavamail.api.mailer.config.TransportStrategy;
import org.simplejavamail.config.ConfigLoader;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.internal.util.SimpleOptional;
import org.simplejavamail.mailer.internal.MailerGenericBuilderImpl;
import org.simplejavamail.mailer.internal.MailerImpl;
import org.simplejavamail.mailer.internal.ServerConfigImpl;

public class MailerRegularBuilderImpl
extends MailerGenericBuilderImpl<MailerRegularBuilderImpl>
implements MailerRegularBuilder<MailerRegularBuilderImpl> {
    private String host;
    private Integer port;
    private String username;
    private String password;
    @NotNull
    private TransportStrategy transportStrategy;

    @Deprecated
    public MailerRegularBuilderImpl() {
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.SMTP_HOST)) {
            this.withSMTPServerHost((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMTP_HOST)));
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.SMTP_PORT)) {
            this.withSMTPServerPort((Integer)Preconditions.assumeNonNull((Object)ConfigLoader.getIntegerProperty((ConfigLoader.Property)ConfigLoader.Property.SMTP_PORT)));
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.SMTP_USERNAME)) {
            this.withSMTPServerUsername((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMTP_USERNAME)));
        }
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.SMTP_PASSWORD)) {
            this.withSMTPServerPassword((String)Preconditions.assumeNonNull((Object)ConfigLoader.getStringProperty((ConfigLoader.Property)ConfigLoader.Property.SMTP_PASSWORD)));
        }
        this.transportStrategy = TransportStrategy.SMTP;
        if (ConfigLoader.hasProperty((ConfigLoader.Property)ConfigLoader.Property.TRANSPORT_STRATEGY)) {
            this.withTransportStrategy((TransportStrategy)Preconditions.assumeNonNull((Object)ConfigLoader.getProperty((ConfigLoader.Property)ConfigLoader.Property.TRANSPORT_STRATEGY)));
        }
    }

    public MailerRegularBuilderImpl withTransportStrategy(@NotNull TransportStrategy transportStrategy) {
        this.transportStrategy = transportStrategy;
        return this;
    }

    public MailerRegularBuilderImpl withSMTPServer(@Nullable String host, @Nullable Integer port, @Nullable String username, @Nullable String password) {
        return this.withSMTPServerHost(host).withSMTPServerPort(port).withSMTPServerUsername(username).withSMTPServerPassword(password);
    }

    public MailerRegularBuilderImpl withSMTPServer(@Nullable String host, @Nullable Integer port, @Nullable String username) {
        return this.withSMTPServerHost(host).withSMTPServerPort(port).withSMTPServerUsername(username);
    }

    public MailerRegularBuilderImpl withSMTPServer(@Nullable String host, @Nullable Integer port) {
        return this.withSMTPServerHost(host).withSMTPServerPort(port);
    }

    public MailerRegularBuilderImpl withSMTPServerHost(@Nullable String host) {
        this.host = host;
        return this;
    }

    public MailerRegularBuilderImpl withSMTPServerPort(@Nullable Integer port) {
        this.port = port;
        return this;
    }

    public MailerRegularBuilderImpl withSMTPServerUsername(@Nullable String username) {
        this.username = username;
        return this;
    }

    public MailerRegularBuilderImpl withSMTPServerPassword(@Nullable String password) {
        this.password = password;
        return this;
    }

    public Mailer buildMailer() {
        return new MailerImpl(this);
    }

    ServerConfig buildServerConfig() {
        this.vallidateServerConfig();
        int serverPort = (Integer)SimpleOptional.ofNullable((Object)this.port).orElse((Object)this.transportStrategy.getDefaultServerPort());
        return new ServerConfigImpl((String)Preconditions.assumeNonNull((Object)this.getHost()), serverPort, this.getUsername(), this.getPassword());
    }

    private void vallidateServerConfig() {
        MiscUtil.checkArgumentNotEmpty((Object)this.host, (String)"SMTP server host missing");
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @NotNull
    public TransportStrategy getTransportStrategy() {
        return this.transportStrategy;
    }
}

