/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.mail.Authenticator;
import javax.mail.Session;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.MailException;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.internal.authenticatedsockssupport.socks5server.AnonymousSocks5Server;
import org.simplejavamail.api.mailer.AsyncResponse;
import org.simplejavamail.api.mailer.Mailer;
import org.simplejavamail.api.mailer.config.OperationalConfig;
import org.simplejavamail.api.mailer.config.ProxyConfig;
import org.simplejavamail.api.mailer.config.ServerConfig;
import org.simplejavamail.api.mailer.config.TransportStrategy;
import org.simplejavamail.internal.modules.ModuleLoader;
import org.simplejavamail.internal.util.ListUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.internal.util.SimpleOptional;
import org.simplejavamail.mailer.MailerHelper;
import org.simplejavamail.mailer.internal.MailerException;
import org.simplejavamail.mailer.internal.MailerFromSessionBuilderImpl;
import org.simplejavamail.mailer.internal.MailerRegularBuilderImpl;
import org.simplejavamail.mailer.internal.SendMailClosure;
import org.simplejavamail.mailer.internal.TestConnectionClosure;
import org.simplejavamail.mailer.internal.util.SmtpAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailerImpl
implements Mailer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailerImpl.class);
    @NotNull
    private final Session session;
    @NotNull
    private final OperationalConfig operationalConfig;
    @Nullable
    private final AnonymousSocks5Server proxyServer;
    @NotNull
    private final AtomicInteger smtpConnectionCounter;
    @NotNull
    private final EnumSet<EmailAddressCriteria> emailAddressCriteria;
    @Nullable
    private final TransportStrategy transportStrategy;
    @Nullable
    private final ServerConfig serverConfig;
    @NotNull
    private final ProxyConfig proxyConfig;

    MailerImpl(@NotNull MailerFromSessionBuilderImpl fromSessionBuilder) {
        if (fromSessionBuilder == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerImpl.<init> must not be null");
        }
        this(null, null, fromSessionBuilder.getEmailAddressCriteria(), fromSessionBuilder.buildProxyConfig(), fromSessionBuilder.getSession(), fromSessionBuilder.buildOperationalConfig());
    }

    MailerImpl(@NotNull MailerRegularBuilderImpl regularBuilder) {
        if (regularBuilder == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerImpl.<init> must not be null");
        }
        this(regularBuilder.buildServerConfig(), regularBuilder.getTransportStrategy(), regularBuilder.getEmailAddressCriteria(), regularBuilder.buildProxyConfig(), null, regularBuilder.buildOperationalConfig());
    }

    MailerImpl(@Nullable ServerConfig serverConfig, @Nullable TransportStrategy transportStrategy, @NotNull EnumSet<EmailAddressCriteria> emailAddressCriteria, @NotNull ProxyConfig proxyConfig, @Nullable Session session, @NotNull OperationalConfig operationalConfig) {
        if (emailAddressCriteria == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/mailer/internal/MailerImpl.<init> must not be null");
        }
        if (proxyConfig == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/simplejavamail/mailer/internal/MailerImpl.<init> must not be null");
        }
        if (operationalConfig == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 5 of org/simplejavamail/mailer/internal/MailerImpl.<init> must not be null");
        }
        this.smtpConnectionCounter = new AtomicInteger();
        this.serverConfig = serverConfig;
        this.transportStrategy = transportStrategy;
        this.emailAddressCriteria = emailAddressCriteria;
        this.proxyConfig = proxyConfig;
        if (session == null) {
            session = MailerImpl.createMailSession((ServerConfig)Preconditions.checkNonEmptyArgument((Object)serverConfig, (String)"serverConfig"), (TransportStrategy)Preconditions.checkNonEmptyArgument((Object)transportStrategy, (String)"transportStrategy"));
        }
        this.session = session;
        this.operationalConfig = operationalConfig;
        TransportStrategy effectiveTransportStrategy = (TransportStrategy)SimpleOptional.ofNullable((Object)transportStrategy).orMaybe((Object)TransportStrategy.findStrategyForSession((Session)session));
        this.proxyServer = MailerImpl.configureSessionWithProxy(proxyConfig, operationalConfig, session, effectiveTransportStrategy);
        this.initSession(session, operationalConfig, effectiveTransportStrategy);
        this.initCluster(session, operationalConfig);
    }

    @NotNull
    public static Session createMailSession(@NotNull ServerConfig serverConfig, @NotNull TransportStrategy transportStrategy) {
        if (serverConfig == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerImpl.createMailSession must not be null");
        }
        if (transportStrategy == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/mailer/internal/MailerImpl.createMailSession must not be null");
        }
        Properties props = transportStrategy.generateProperties();
        props.put(transportStrategy.propertyNameHost(), serverConfig.getHost());
        props.put(transportStrategy.propertyNamePort(), String.valueOf(serverConfig.getPort()));
        if (serverConfig.getUsername() != null) {
            props.put(transportStrategy.propertyNameUsername(), serverConfig.getUsername());
        }
        if (serverConfig.getPassword() != null) {
            props.put(transportStrategy.propertyNameAuthenticate(), "true");
            Session session = Session.getInstance((Properties)props, (Authenticator)new SmtpAuthenticator(serverConfig));
            if (session == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerImpl.createMailSession must not return null");
            }
            return session;
        }
        Session session = Session.getInstance((Properties)props);
        if (session == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerImpl.createMailSession must not return null");
        }
        return session;
    }

    private void initSession(@NotNull Session session, @NotNull OperationalConfig operationalConfig, @Nullable TransportStrategy transportStrategy) {
        if (session == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerImpl.initSession must not be null");
        }
        if (operationalConfig == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/mailer/internal/MailerImpl.initSession must not be null");
        }
        session.setDebug(operationalConfig.isDebugLogging());
        session.getProperties().putAll((Map<?, ?>)operationalConfig.getProperties());
        this.configureSessionWithTimeout(session, operationalConfig.getSessionTimeout(), transportStrategy);
        this.configureTrustedHosts(session, operationalConfig, transportStrategy);
        this.configureServerIdentityVerification(session, operationalConfig, transportStrategy);
    }

    private void configureSessionWithTimeout(@NotNull Session session, int sessionTimeout, @Nullable TransportStrategy transportStrategy) {
        if (session == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerImpl.configureSessionWithTimeout must not be null");
        }
        if (transportStrategy != null) {
            Properties sessionProperties = session.getProperties();
            sessionProperties.put(transportStrategy.propertyNameConnectionTimeout(), String.valueOf(sessionTimeout));
            sessionProperties.put(transportStrategy.propertyNameTimeout(), String.valueOf(sessionTimeout));
            sessionProperties.put(transportStrategy.propertyNameWriteTimeout(), String.valueOf(sessionTimeout));
        } else {
            LOGGER.debug("No transport strategy provided, skipping defaults for .connectiontimout, .timout and .writetimeout");
        }
    }

    private void configureTrustedHosts(@NotNull Session session, @NotNull OperationalConfig operationalConfig, @Nullable TransportStrategy transportStrategy) {
        if (session == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerImpl.configureTrustedHosts must not be null");
        }
        if (operationalConfig == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/mailer/internal/MailerImpl.configureTrustedHosts must not be null");
        }
        if (transportStrategy != null) {
            if (operationalConfig.isTrustAllSSLHost()) {
                session.getProperties().setProperty(transportStrategy.propertyNameSSLTrust(), "*");
            } else {
                List hosts = operationalConfig.getSslHostsToTrust();
                String sslPropertyForTrustingHosts = transportStrategy.propertyNameSSLTrust();
                session.getProperties().remove(sslPropertyForTrustingHosts);
                if (!hosts.isEmpty()) {
                    StringBuilder builder = new StringBuilder((String)ListUtil.getFirst((List)hosts));
                    for (int i = 1; i < hosts.size(); ++i) {
                        builder.append(" ").append((String)hosts.get(i));
                    }
                    session.getProperties().setProperty(sslPropertyForTrustingHosts, builder.toString());
                }
            }
        } else {
            LOGGER.debug("No transport strategy provided, skipping configuration for trusted hosts");
        }
    }

    private void configureServerIdentityVerification(@NotNull Session session, @NotNull OperationalConfig operationalConfig, @Nullable TransportStrategy transportStrategy) {
        if (session == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerImpl.configureServerIdentityVerification must not be null");
        }
        if (operationalConfig == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/mailer/internal/MailerImpl.configureServerIdentityVerification must not be null");
        }
        if (transportStrategy != null && transportStrategy != TransportStrategy.SMTP) {
            session.getProperties().setProperty(transportStrategy.propertyNameCheckServerIdentity(), Boolean.toString(operationalConfig.isVerifyingServerIdentity()));
        }
    }

    @Nullable
    private static AnonymousSocks5Server configureSessionWithProxy(@NotNull ProxyConfig proxyConfig, @NotNull OperationalConfig operationalConfig, @NotNull Session session, @Nullable TransportStrategy transportStrategy) {
        if (proxyConfig == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerImpl.configureSessionWithProxy must not be null");
        }
        if (operationalConfig == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/mailer/internal/MailerImpl.configureSessionWithProxy must not be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/mailer/internal/MailerImpl.configureSessionWithProxy must not be null");
        }
        if (operationalConfig.getCustomMailer() != null) {
            LOGGER.trace("CustomMailer provided by user, skipping proxy.");
        } else if (!proxyConfig.requiresProxy()) {
            LOGGER.trace("No proxy set, skipping proxy.");
        } else {
            if (transportStrategy == TransportStrategy.SMTPS) {
                throw new MailerException("Proxy is not supported for SSL connections (this is a limitation by the underlying JavaMail framework)");
            }
            Properties sessionProperties = session.getProperties();
            if (transportStrategy != null) {
                sessionProperties.put(transportStrategy.propertyNameSocksHost(), Preconditions.assumeNonNull((Object)proxyConfig.getRemoteProxyHost()));
                sessionProperties.put(transportStrategy.propertyNameSocksPort(), String.valueOf(proxyConfig.getRemoteProxyPort()));
            } else {
                LOGGER.debug("no transport strategy provided, expecting mail.smtp(s).socks.host and .port properties to be set to proxy config on Session");
            }
            if (proxyConfig.requiresAuthentication()) {
                if (transportStrategy != null) {
                    sessionProperties.put(transportStrategy.propertyNameSocksHost(), "localhost");
                    sessionProperties.put(transportStrategy.propertyNameSocksPort(), String.valueOf(proxyConfig.getProxyBridgePort()));
                } else {
                    LOGGER.debug("no transport strategy provided but authenticated proxy required, expecting mail.smtp(s).socks.host and .port properties to be set to localhost and port " + proxyConfig.getProxyBridgePort());
                }
                return ModuleLoader.loadAuthenticatedSocksModule().createAnonymousSocks5Server(proxyConfig);
            }
        }
        return null;
    }

    private void initCluster(@NotNull Session session, @NotNull OperationalConfig operationalConfig) {
        if (session == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerImpl.initCluster must not be null");
        }
        if (operationalConfig == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/mailer/internal/MailerImpl.initCluster must not be null");
        }
        if (operationalConfig.getCustomMailer() == null && ModuleLoader.batchModuleAvailable()) {
            ModuleLoader.loadBatchModule().registerToCluster(operationalConfig, operationalConfig.getClusterKey(), session);
        }
    }

    public void testConnection() {
        this.testConnection(false);
    }

    @Nullable
    public synchronized AsyncResponse testConnection(boolean async) {
        TestConnectionClosure testConnectionClosure = new TestConnectionClosure(this.operationalConfig, this.session, this.proxyServer, async, this.smtpConnectionCounter);
        if (!async) {
            testConnectionClosure.run();
            return null;
        }
        return ModuleLoader.loadBatchModule().executeAsync("testSMTPConnection process", (Runnable)testConnectionClosure);
    }

    public final void sendMail(Email email) {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerImpl.sendMail must not be null");
        }
        this.sendMail(email, this.getOperationalConfig().isAsync());
    }

    @Nullable
    public final AsyncResponse sendMail(Email email, boolean async) {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerImpl.sendMail must not be null");
        }
        if (this.validate(email)) {
            SendMailClosure sendMailClosure = new SendMailClosure(this.operationalConfig, this.session, email, this.proxyServer, async, this.operationalConfig.isTransportModeLoggingOnly(), this.smtpConnectionCounter);
            if (!async) {
                sendMailClosure.run();
                return null;
            }
            return ModuleLoader.loadBatchModule().executeAsync(this.operationalConfig.getExecutorService(), "sendMail process", (Runnable)sendMailClosure);
        }
        throw new AssertionError((Object)"Email not valid, but no MailException was thrown for it");
    }

    public boolean validate(@NotNull Email email) throws MailException {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/mailer/internal/MailerImpl.validate must not be null");
        }
        return MailerHelper.validate(email, this.emailAddressCriteria);
    }

    public Future<?> shutdownConnectionPool() {
        Future future = ModuleLoader.loadBatchModule().shutdownConnectionPools(this.session);
        if (future == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerImpl.shutdownConnectionPool must not return null");
        }
        return future;
    }

    public Session getSession() {
        LOGGER.warn("Providing access to Session instance for emergency fall-back scenario. Please let us know why you need it.");
        LOGGER.warn("\t\t> https://github.com/bbottema/simple-java-mail/issues");
        Session session = this.session;
        if (session == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerImpl.getSession must not return null");
        }
        return session;
    }

    @Nullable
    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    @Nullable
    public TransportStrategy getTransportStrategy() {
        return this.transportStrategy;
    }

    @NotNull
    public ProxyConfig getProxyConfig() {
        ProxyConfig proxyConfig = this.proxyConfig;
        if (proxyConfig == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerImpl.getProxyConfig must not return null");
        }
        return proxyConfig;
    }

    @NotNull
    public OperationalConfig getOperationalConfig() {
        OperationalConfig operationalConfig = this.operationalConfig;
        if (operationalConfig == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerImpl.getOperationalConfig must not return null");
        }
        return operationalConfig;
    }

    @NotNull
    public EnumSet<EmailAddressCriteria> getEmailAddressCriteria() {
        EnumSet<EmailAddressCriteria> enumSet = this.emailAddressCriteria;
        if (enumSet == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/mailer/internal/MailerImpl.getEmailAddressCriteria must not return null");
        }
        return enumSet;
    }
}

