/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.simplejavamail.internal.modules.AuthenticatedSocksModule;
import org.simplejavamail.internal.modules.BatchModule;
import org.simplejavamail.internal.modules.DKIMModule;
import org.simplejavamail.internal.modules.ModuleLoaderException;
import org.simplejavamail.internal.modules.OutlookModule;
import org.simplejavamail.internal.modules.SMIMEModule;
import org.simplejavamail.internal.util.MiscUtil;

public class ModuleLoader {
    private static final Map<Class, Object> LOADED_MODULES = new HashMap<Class, Object>();
    private static final Collection<Class> FORCED_DISABLED_MODULES = new ArrayList<Class>();

    public static void clearLoadedModules() {
        LOADED_MODULES.clear();
    }

    public static AuthenticatedSocksModule loadAuthenticatedSocksModule() {
        if (!LOADED_MODULES.containsKey(AuthenticatedSocksModule.class)) {
            LOADED_MODULES.put(AuthenticatedSocksModule.class, ModuleLoader.loadModule(AuthenticatedSocksModule.class, "Authenticated Socks", "org.simplejavamail.internal.authenticatedsockssupport.AuthenticatedSocksHelper", "https://github.com/bbottema/simple-java-mail/tree/develop/modules/authenticated-socks-module"));
        }
        AuthenticatedSocksModule authenticatedSocksModule = (AuthenticatedSocksModule)LOADED_MODULES.get(AuthenticatedSocksModule.class);
        if (authenticatedSocksModule == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/modules/ModuleLoader.loadAuthenticatedSocksModule must not return null");
        }
        return authenticatedSocksModule;
    }

    public static DKIMModule loadDKIMModule() {
        if (!LOADED_MODULES.containsKey(DKIMModule.class)) {
            LOADED_MODULES.put(DKIMModule.class, ModuleLoader.loadModule(DKIMModule.class, "DKIM", "org.simplejavamail.internal.dkimsupport.DKIMSigner", "https://github.com/bbottema/simple-java-mail/tree/develop/modules/dkim-module"));
        }
        DKIMModule dKIMModule = (DKIMModule)LOADED_MODULES.get(DKIMModule.class);
        if (dKIMModule == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/modules/ModuleLoader.loadDKIMModule must not return null");
        }
        return dKIMModule;
    }

    public static OutlookModule loadOutlookModule() {
        if (!LOADED_MODULES.containsKey(OutlookModule.class)) {
            LOADED_MODULES.put(OutlookModule.class, ModuleLoader.loadModule(OutlookModule.class, "Outlook", "org.simplejavamail.internal.outlooksupport.converter.OutlookEmailConverter", "https://github.com/bbottema/simple-java-mail/tree/develop/modules/outlook-module"));
        }
        OutlookModule outlookModule = (OutlookModule)LOADED_MODULES.get(OutlookModule.class);
        if (outlookModule == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/modules/ModuleLoader.loadOutlookModule must not return null");
        }
        return outlookModule;
    }

    public static SMIMEModule loadSmimeModule() {
        if (!LOADED_MODULES.containsKey(SMIMEModule.class)) {
            LOADED_MODULES.put(SMIMEModule.class, ModuleLoader.loadModule(SMIMEModule.class, "S/MIME", "org.simplejavamail.internal.smimesupport.SMIMESupport", "https://github.com/bbottema/simple-java-mail/tree/develop/modules/smime-module"));
        }
        SMIMEModule sMIMEModule = (SMIMEModule)LOADED_MODULES.get(SMIMEModule.class);
        if (sMIMEModule == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/modules/ModuleLoader.loadSmimeModule must not return null");
        }
        return sMIMEModule;
    }

    public static BatchModule loadBatchModule() {
        if (!LOADED_MODULES.containsKey(BatchModule.class)) {
            LOADED_MODULES.put(BatchModule.class, ModuleLoader.loadModule(BatchModule.class, "Batch", "org.simplejavamail.internal.batchsupport.BatchSupport", "https://github.com/bbottema/simple-java-mail/tree/develop/modules/batch-module"));
        }
        BatchModule batchModule = (BatchModule)LOADED_MODULES.get(BatchModule.class);
        if (batchModule == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/modules/ModuleLoader.loadBatchModule must not return null");
        }
        return batchModule;
    }

    public static boolean batchModuleAvailable() {
        return !FORCED_DISABLED_MODULES.contains(BatchModule.class) && MiscUtil.classAvailable((String)"org.simplejavamail.internal.batchsupport.BatchSupport");
    }

    public static boolean smimeModuleAvailable() {
        return !FORCED_DISABLED_MODULES.contains(SMIMEModule.class) && MiscUtil.classAvailable((String)"org.simplejavamail.internal.smimesupport.SMIMESupport");
    }

    private static <T> T loadModule(Class moduleClass, String moduleName, String moduleImplClassName, String moduleHome) {
        Object obj;
        if (moduleClass == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/modules/ModuleLoader.loadModule must not be null");
        }
        if (moduleName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/internal/modules/ModuleLoader.loadModule must not be null");
        }
        if (moduleImplClassName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/internal/modules/ModuleLoader.loadModule must not be null");
        }
        if (moduleHome == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/simplejavamail/internal/modules/ModuleLoader.loadModule must not be null");
        }
        try {
            if (FORCED_DISABLED_MODULES.contains(moduleClass)) {
                throw new IllegalAccessException("Module is focrfully disabled");
            }
            if (!MiscUtil.classAvailable((String)moduleImplClassName)) {
                throw new ModuleLoaderException(String.format("%s module not found, make sure it is on the classpath (%s)", moduleName, moduleHome));
            }
            obj = Class.forName(moduleImplClassName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new ModuleLoaderException(String.format("Error loading %s module...", moduleName), e);
        }
        if (obj == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/modules/ModuleLoader.loadModule must not return null");
        }
        return (T)obj;
    }

    public static void _forceDisableBatchModule() {
        FORCED_DISABLED_MODULES.add(BatchModule.class);
    }
}

