/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.email.internal;

import java.util.Collection;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.EmailPopulatingBuilder;
import org.simplejavamail.api.email.EmailStartingBuilder;
import org.simplejavamail.converter.EmailConverter;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageParser;
import org.simplejavamail.email.internal.EmailException;
import org.simplejavamail.email.internal.EmailPopulatingBuilderImpl;
import org.simplejavamail.email.internal.InternalEmailPopulatingBuilder;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;

public final class EmailStartingBuilderImpl
implements EmailStartingBuilder {
    private boolean applyDefaults = true;

    @Deprecated
    public EmailStartingBuilderImpl() {
    }

    public EmailStartingBuilder ignoringDefaults() {
        this.applyDefaults = false;
        EmailStartingBuilderImpl emailStartingBuilderImpl = this;
        if (emailStartingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailStartingBuilderImpl.ignoringDefaults must not return null");
        }
        return emailStartingBuilderImpl;
    }

    public EmailPopulatingBuilder startingBlank() {
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = new EmailPopulatingBuilderImpl(this.applyDefaults);
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailStartingBuilderImpl.startingBlank must not return null");
        }
        return emailPopulatingBuilderImpl;
    }

    public EmailPopulatingBuilder replyingTo(@NotNull Email email) {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingTo must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.replyingTo(EmailConverter.emailToMimeMessage(email), false, "<blockquote style=\"color: gray; border-left: 1px solid #4f4f4f; padding-left: 1cm\">%s</blockquote>");
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder replyingToAll(@NotNull Email email) {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingToAll must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.replyingTo(EmailConverter.emailToMimeMessage(email), true, "<blockquote style=\"color: gray; border-left: 1px solid #4f4f4f; padding-left: 1cm\">%s</blockquote>");
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingToAll must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder replyingToAll(@NotNull Email email, @NotNull String customQuotingTemplate) {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingToAll must not be null");
        }
        if (customQuotingTemplate == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingToAll must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.replyingTo(EmailConverter.emailToMimeMessage(email), true, customQuotingTemplate);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingToAll must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder replyingTo(@NotNull Email email, @NotNull String customQuotingTemplate) {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingTo must not be null");
        }
        if (customQuotingTemplate == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingTo must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.replyingTo(EmailConverter.emailToMimeMessage(email), false, customQuotingTemplate);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder replyingTo(@NotNull MimeMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingTo must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.replyingTo(message, false, "<blockquote style=\"color: gray; border-left: 1px solid #4f4f4f; padding-left: 1cm\">%s</blockquote>");
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder replyingTo(@NotNull MimeMessage message, @NotNull String customQuotingTemplate) {
        if (message == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingTo must not be null");
        }
        if (customQuotingTemplate == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingTo must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.replyingTo(message, false, customQuotingTemplate);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder replyingToAll(@NotNull MimeMessage message, @NotNull String customQuotingTemplate) {
        if (message == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingToAll must not be null");
        }
        if (customQuotingTemplate == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingToAll must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.replyingTo(message, true, customQuotingTemplate);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingToAll must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder replyingToAll(@NotNull MimeMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingToAll must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.replyingTo(message, true, "<blockquote style=\"color: gray; border-left: 1px solid #4f4f4f; padding-left: 1cm\">%s</blockquote>");
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingToAll must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder replyingTo(@NotNull MimeMessage emailMessage, boolean repyToAll, @NotNull String htmlTemplate) {
        MimeMessage replyMessage;
        if (emailMessage == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingTo must not be null");
        }
        if (htmlTemplate == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingTo must not be null");
        }
        try {
            replyMessage = (MimeMessage)emailMessage.reply(repyToAll);
            replyMessage.setText("ignore");
            replyMessage.setFrom("ignore@ignore.ignore");
        }
        catch (MessagingException e) {
            throw new EmailException("was unable to parse mimemessage to produce a reply for", (Exception)((Object)e));
        }
        Email repliedTo = EmailConverter.mimeMessageToEmail(emailMessage);
        Email generatedReply = EmailConverter.mimeMessageToEmail(replyMessage);
        EmailPopulatingBuilder emailPopulatingBuilder = this.startingBlank().withSubject(generatedReply.getSubject()).to((Collection)generatedReply.getRecipients()).withPlainText(EmailStartingBuilder.LINE_START_PATTERN.matcher((CharSequence)MiscUtil.defaultTo((Object)repliedTo.getPlainText(), (Object)"")).replaceAll("> ")).withHTMLText(String.format(htmlTemplate, MiscUtil.defaultTo((Object)repliedTo.getHTMLText(), (Object)""))).withHeaders(generatedReply.getHeaders()).withEmbeddedImages(repliedTo.getEmbeddedImages());
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailStartingBuilderImpl.replyingTo must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder forwarding(@NotNull Email email) {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.forwarding must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.forwarding(EmailConverter.emailToMimeMessage(email));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailStartingBuilderImpl.forwarding must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder forwarding(@NotNull MimeMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.forwarding must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = ((InternalEmailPopulatingBuilder)this.startingBlank()).withForward(message).withSubject("Fwd: " + MimeMessageParser.parseSubject(message));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailStartingBuilderImpl.forwarding must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder copying(@NotNull MimeMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.copying must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.copying(EmailConverter.mimeMessageToEmail(message));
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailStartingBuilderImpl.copying must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder copying(@NotNull EmailPopulatingBuilder emailBuilder) {
        if (emailBuilder == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.copying must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = this.copying(emailBuilder.buildEmail());
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailStartingBuilderImpl.copying must not return null");
        }
        return emailPopulatingBuilder;
    }

    public EmailPopulatingBuilder copying(@NotNull Email email) {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/email/internal/EmailStartingBuilderImpl.copying must not be null");
        }
        EmailPopulatingBuilderImpl builder = new EmailPopulatingBuilderImpl(this.applyDefaults);
        if (email.getId() != null) {
            builder.fixingMessageId(email.getId());
        }
        if (email.getFromRecipient() != null) {
            builder.from(email.getFromRecipient());
        }
        if (email.getReplyToRecipient() != null) {
            builder.withReplyTo(email.getReplyToRecipient());
        }
        if (email.getBounceToRecipient() != null) {
            builder.withBounceTo(email.getBounceToRecipient());
        }
        if (email.getPlainText() != null) {
            builder.withPlainText(email.getPlainText());
        }
        if (email.getHTMLText() != null) {
            builder.withHTMLText(email.getHTMLText());
        }
        if (email.getSubject() != null) {
            builder.withSubject(email.getSubject());
        }
        builder.withRecipients(email.getRecipients());
        builder.withEmbeddedImages(email.getEmbeddedImages());
        builder.withAttachments(email.getAttachments());
        ((InternalEmailPopulatingBuilder)builder).withHeaders(email.getHeaders(), true);
        if (email.getSentDate() != null) {
            builder.fixingSentDate(email.getSentDate());
        }
        if (email.getDkimPrivateKeyFile() != null) {
            builder.signWithDomainKey(email.getDkimPrivateKeyFile(), (String)Preconditions.assumeNonNull((Object)email.getDkimSigningDomain()), (String)Preconditions.assumeNonNull((Object)email.getDkimSelector()));
        }
        if (email.getDkimPrivateKeyInputStream() != null) {
            builder.signWithDomainKey(email.getDkimPrivateKeyInputStream(), (String)Preconditions.assumeNonNull((Object)email.getDkimSigningDomain()), (String)Preconditions.assumeNonNull((Object)email.getDkimSelector()));
        }
        if (email.getDispositionNotificationTo() != null) {
            builder.withDispositionNotificationTo(email.getDispositionNotificationTo());
        }
        if (email.getReturnReceiptTo() != null) {
            builder.withReturnReceiptTo(email.getReturnReceiptTo());
        }
        if (email.getEmailToForward() != null) {
            ((InternalEmailPopulatingBuilder)builder).withForward(email.getEmailToForward());
        }
        ((InternalEmailPopulatingBuilder)builder).withDecryptedAttachments(email.getDecryptedAttachments());
        if (email.getSmimeSignedEmail() != null) {
            ((InternalEmailPopulatingBuilder)builder).withSmimeSignedEmail(email.getSmimeSignedEmail());
        }
        ((InternalEmailPopulatingBuilder)builder).withOriginalSmimeDetails(email.getOriginalSmimeDetails());
        if (!email.wasMergedWithSmimeSignedMessage()) {
            builder.notMergingSingleSMIMESignedAttachment();
        }
        EmailPopulatingBuilderImpl emailPopulatingBuilderImpl = builder;
        if (emailPopulatingBuilderImpl == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/email/internal/EmailStartingBuilderImpl.copying must not return null");
        }
        return emailPopulatingBuilderImpl;
    }
}

