/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageHelper;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProduceException;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducer;

class MimeMessageProducerRelatedAlternative
extends MimeMessageProducer {
    MimeMessageProducerRelatedAlternative() {
    }

    @Override
    boolean compatibleWithEmail(@NotNull Email email) {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/internal/mimemessage/MimeMessageProducerRelatedAlternative.compatibleWithEmail must not be null");
        }
        return !MimeMessageProducerRelatedAlternative.emailContainsMixedContent(email) && MimeMessageProducerRelatedAlternative.emailContainsRelatedContent(email) && MimeMessageProducerRelatedAlternative.emailContainsAlternativeContent(email);
    }

    @Override
    public void populateMimeMessageMultipartStructure(@NotNull MimeMessage message, @NotNull Email email) throws MessagingException {
        if (message == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/internal/mimemessage/MimeMessageProducerRelatedAlternative.populateMimeMessageMultipartStructure must not be null");
        }
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/internal/mimemessage/MimeMessageProducerRelatedAlternative.populateMimeMessageMultipartStructure must not be null");
        }
        MultipartStructureWrapper multipartStructureWrapper = new MultipartStructureWrapper();
        MimeMessageHelper.setTexts(email, multipartStructureWrapper.multipartAlternativeMessages);
        MimeMessageHelper.setEmbeddedImages(email, multipartStructureWrapper.multipartRootRelated);
        message.setContent((Multipart)multipartStructureWrapper.multipartRootRelated);
    }

    private static class MultipartStructureWrapper {
        private final MimeMultipart multipartRootRelated = new MimeMultipart("related");
        private final MimeMultipart multipartAlternativeMessages;

        private MultipartStructureWrapper() {
            MimeBodyPart contentRelated = new MimeBodyPart();
            this.multipartAlternativeMessages = new MimeMultipart("alternative");
            MimeBodyPart contentAlternativeMessages = new MimeBodyPart();
            try {
                contentRelated.setContent((Multipart)this.multipartRootRelated);
                this.multipartRootRelated.addBodyPart((BodyPart)contentAlternativeMessages);
                contentAlternativeMessages.setContent((Multipart)this.multipartAlternativeMessages);
            }
            catch (MessagingException e) {
                throw new MimeMessageProduceException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }
}

