/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.CalendarMethod;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.EmailPopulatingBuilder;
import org.simplejavamail.api.email.EmailStartingBuilder;
import org.simplejavamail.api.email.OriginalSmimeDetails;
import org.simplejavamail.api.internal.outlooksupport.model.EmailFromOutlookMessage;
import org.simplejavamail.api.internal.outlooksupport.model.OutlookMessage;
import org.simplejavamail.api.internal.smimesupport.builder.SmimeParseResult;
import org.simplejavamail.api.mailer.config.Pkcs12Config;
import org.simplejavamail.converter.EmailConverterException;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageParser;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerHelper;
import org.simplejavamail.email.EmailBuilder;
import org.simplejavamail.email.internal.EmailStartingBuilderImpl;
import org.simplejavamail.email.internal.InternalEmailPopulatingBuilder;
import org.simplejavamail.internal.modules.ModuleLoader;
import org.simplejavamail.internal.smimesupport.model.OriginalSmimeDetailsImpl;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;

public final class EmailConverter {
    private static final PathMatcher EML_PATH_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**/*.eml");
    private static final PathMatcher MSG_PATH_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**/*.msg");

    private EmailConverter() {
    }

    @NotNull
    public static Email mimeMessageToEmail(@NotNull MimeMessage mimeMessage) {
        if (mimeMessage == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.mimeMessageToEmail must not be null");
        }
        Email email = EmailConverter.mimeMessageToEmail(mimeMessage, null);
        if (email == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.mimeMessageToEmail must not return null");
        }
        return email;
    }

    @NotNull
    public static Email mimeMessageToEmail(@NotNull MimeMessage mimeMessage, @Nullable Pkcs12Config pkcs12Config) {
        if (mimeMessage == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.mimeMessageToEmail must not be null");
        }
        Email email = EmailConverter.mimeMessageToEmailBuilder(mimeMessage, pkcs12Config).buildEmail();
        if (email == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.mimeMessageToEmail must not return null");
        }
        return email;
    }

    @NotNull
    public static EmailPopulatingBuilder mimeMessageToEmailBuilder(@NotNull MimeMessage mimeMessage) {
        if (mimeMessage == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.mimeMessageToEmailBuilder must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = EmailConverter.mimeMessageToEmailBuilder(mimeMessage, null);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.mimeMessageToEmailBuilder must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public static EmailPopulatingBuilder mimeMessageToEmailBuilder(@NotNull MimeMessage mimeMessage, @Nullable Pkcs12Config pkcs12Config) {
        if (mimeMessage == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.mimeMessageToEmailBuilder must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)mimeMessage, (String)"mimeMessage");
        EmailPopulatingBuilder builder = EmailBuilder.ignoringDefaults().startingBlank();
        MimeMessageParser.ParsedMimeMessageComponents parsed = MimeMessageParser.parseMimeMessage(mimeMessage);
        EmailPopulatingBuilder emailPopulatingBuilder = EmailConverter.decryptAttachments(EmailConverter.buildEmailFromMimeMessage(builder, parsed), mimeMessage, pkcs12Config);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.mimeMessageToEmailBuilder must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public static Email outlookMsgToEmail(@NotNull String msgData) {
        if (msgData == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToEmail must not be null");
        }
        Email email = EmailConverter.outlookMsgToEmail(msgData, null);
        if (email == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToEmail must not return null");
        }
        return email;
    }

    @NotNull
    public static Email outlookMsgToEmail(@NotNull String msgData, @Nullable Pkcs12Config pkcs12Config) {
        if (msgData == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToEmail must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)msgData, (String)"msgFile");
        EmailFromOutlookMessage result = ModuleLoader.loadOutlookModule().outlookMsgToEmailBuilder(msgData, (EmailStartingBuilder)new EmailStartingBuilderImpl());
        Email email = EmailConverter.decryptAttachments(result.getEmailBuilder(), result.getOutlookMessage(), pkcs12Config).buildEmail();
        if (email == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToEmail must not return null");
        }
        return email;
    }

    @NotNull
    public static Email outlookMsgToEmail(@NotNull File msgFile) {
        if (msgFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToEmail must not be null");
        }
        Email email = EmailConverter.outlookMsgToEmailBuilder(msgFile).buildEmail();
        if (email == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToEmail must not return null");
        }
        return email;
    }

    @NotNull
    public static Email outlookMsgToEmail(@NotNull File msgFile, @Nullable Pkcs12Config pkcs12Config) {
        if (msgFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToEmail must not be null");
        }
        Email email = EmailConverter.outlookMsgToEmailBuilder(msgFile, pkcs12Config).buildEmail();
        if (email == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToEmail must not return null");
        }
        return email;
    }

    @NotNull
    public static EmailPopulatingBuilder outlookMsgToEmailBuilder(@NotNull File msgFile) {
        if (msgFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToEmailBuilder must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = EmailConverter.outlookMsgToEmailBuilder(msgFile, null);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToEmailBuilder must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public static EmailPopulatingBuilder outlookMsgToEmailBuilder(@NotNull File msgFile, @Nullable Pkcs12Config pkcs12Config) {
        if (msgFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToEmailBuilder must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)msgFile, (String)"msgFile");
        if (!MSG_PATH_MATCHER.matches(msgFile.toPath())) {
            throw new EmailConverterException(String.format("Outlook file should have \".msg\" extension: %s", msgFile));
        }
        EmailFromOutlookMessage result = ModuleLoader.loadOutlookModule().outlookMsgToEmailBuilder(msgFile, (EmailStartingBuilder)new EmailStartingBuilderImpl());
        EmailPopulatingBuilder emailPopulatingBuilder = EmailConverter.decryptAttachments(result.getEmailBuilder(), result.getOutlookMessage(), pkcs12Config);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToEmailBuilder must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public static Email outlookMsgToEmail(@NotNull InputStream msgInputStream) {
        if (msgInputStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToEmail must not be null");
        }
        Email email = EmailConverter.outlookMsgToEmail(msgInputStream, null);
        if (email == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToEmail must not return null");
        }
        return email;
    }

    @NotNull
    public static Email outlookMsgToEmail(@NotNull InputStream msgInputStream, @Nullable Pkcs12Config pkcs12Config) {
        if (msgInputStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToEmail must not be null");
        }
        Email email = EmailConverter.outlookMsgToEmailBuilder(msgInputStream, pkcs12Config).getEmailBuilder().buildEmail();
        if (email == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToEmail must not return null");
        }
        return email;
    }

    @NotNull
    public static EmailFromOutlookMessage outlookMsgToEmailBuilder(@NotNull InputStream msgInputStream) {
        if (msgInputStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToEmailBuilder must not be null");
        }
        EmailFromOutlookMessage emailFromOutlookMessage = EmailConverter.outlookMsgToEmailBuilder(msgInputStream, null);
        if (emailFromOutlookMessage == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToEmailBuilder must not return null");
        }
        return emailFromOutlookMessage;
    }

    @NotNull
    public static EmailFromOutlookMessage outlookMsgToEmailBuilder(@NotNull InputStream msgInputStream, @Nullable Pkcs12Config pkcs12Config) {
        if (msgInputStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToEmailBuilder must not be null");
        }
        EmailFromOutlookMessage fromMsgBuilder = ModuleLoader.loadOutlookModule().outlookMsgToEmailBuilder(msgInputStream, (EmailStartingBuilder)new EmailStartingBuilderImpl());
        EmailConverter.decryptAttachments(fromMsgBuilder.getEmailBuilder(), fromMsgBuilder.getOutlookMessage(), pkcs12Config);
        EmailFromOutlookMessage emailFromOutlookMessage = fromMsgBuilder;
        if (emailFromOutlookMessage == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToEmailBuilder must not return null");
        }
        return emailFromOutlookMessage;
    }

    private static EmailPopulatingBuilder decryptAttachments(EmailPopulatingBuilder emailBuilder, OutlookMessage outlookMessage, @Nullable Pkcs12Config pkcs12Config) {
        if (emailBuilder == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.decryptAttachments must not be null");
        }
        if (outlookMessage == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/EmailConverter.decryptAttachments must not be null");
        }
        if (ModuleLoader.smimeModuleAvailable()) {
            SmimeParseResult smimeParseResult = ModuleLoader.loadSmimeModule().decryptAttachments(emailBuilder.getAttachments(), outlookMessage, pkcs12Config);
            EmailConverter.handleSmimeParseResult((InternalEmailPopulatingBuilder)emailBuilder, smimeParseResult);
            EmailConverter.updateEmailIfBothSignedAndEncrypted(emailBuilder);
        }
        EmailPopulatingBuilder emailPopulatingBuilder = emailBuilder;
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.decryptAttachments must not return null");
        }
        return emailPopulatingBuilder;
    }

    private static EmailPopulatingBuilder decryptAttachments(EmailPopulatingBuilder emailBuilder, MimeMessage mimeMessage, @Nullable Pkcs12Config pkcs12Config) {
        if (emailBuilder == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.decryptAttachments must not be null");
        }
        if (mimeMessage == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/EmailConverter.decryptAttachments must not be null");
        }
        if (ModuleLoader.smimeModuleAvailable()) {
            SmimeParseResult smimeParseResult = ModuleLoader.loadSmimeModule().decryptAttachments(emailBuilder.getAttachments(), mimeMessage, pkcs12Config);
            EmailConverter.handleSmimeParseResult((InternalEmailPopulatingBuilder)emailBuilder, smimeParseResult);
            EmailConverter.updateEmailIfBothSignedAndEncrypted(emailBuilder);
        }
        EmailPopulatingBuilder emailPopulatingBuilder = emailBuilder;
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.decryptAttachments must not return null");
        }
        return emailPopulatingBuilder;
    }

    private static void updateEmailIfBothSignedAndEncrypted(EmailPopulatingBuilder emailBuilder) {
        if (emailBuilder == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.updateEmailIfBothSignedAndEncrypted must not be null");
        }
        if (emailBuilder.getSmimeSignedEmail() != null) {
            OriginalSmimeDetails nestedSmime = emailBuilder.getSmimeSignedEmail().getOriginalSmimeDetails();
            OriginalSmimeDetailsImpl originalSmimeDetails = (OriginalSmimeDetailsImpl)emailBuilder.getOriginalSmimeDetails();
            if (nestedSmime.getSmimeMode() != OriginalSmimeDetails.SmimeMode.PLAIN && nestedSmime.getSmimeMode() != originalSmimeDetails.getSmimeMode()) {
                originalSmimeDetails.completeWithSmimeMode(OriginalSmimeDetails.SmimeMode.SIGNED_ENCRYPTED);
            }
        }
    }

    private static void handleSmimeParseResult(InternalEmailPopulatingBuilder emailBuilder, SmimeParseResult smimeParseResult) {
        if (emailBuilder == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.handleSmimeParseResult must not be null");
        }
        if (smimeParseResult == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/EmailConverter.handleSmimeParseResult must not be null");
        }
        emailBuilder.withDecryptedAttachments(smimeParseResult.getDecryptedAttachments());
        emailBuilder.withOriginalSmimeDetails(smimeParseResult.getOriginalSmimeDetails());
        if (smimeParseResult.getSmimeSignedEmail() != null) {
            emailBuilder.withSmimeSignedEmail(EmailConverter.emlToEmail(smimeParseResult.getSmimeSignedEmail().getDataSourceInputStream()));
        }
    }

    @NotNull
    public static Email emlToEmail(@NotNull InputStream emlInputStream) {
        if (emlInputStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToEmail must not be null");
        }
        Email email = EmailConverter.emlToEmail(emlInputStream, null);
        if (email == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToEmail must not return null");
        }
        return email;
    }

    @NotNull
    public static Email emlToEmail(@NotNull InputStream emlInputStream, @Nullable Pkcs12Config pkcs12Config) {
        if (emlInputStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToEmail must not be null");
        }
        Email email = EmailConverter.emlToEmailBuilder(emlInputStream, pkcs12Config).buildEmail();
        if (email == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToEmail must not return null");
        }
        return email;
    }

    @NotNull
    public static Email emlToEmail(@NotNull String eml) {
        if (eml == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToEmail must not be null");
        }
        Email email = EmailConverter.emlToEmail(eml, null);
        if (email == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToEmail must not return null");
        }
        return email;
    }

    @NotNull
    public static Email emlToEmail(@NotNull String eml, @Nullable Pkcs12Config pkcs12Config) {
        if (eml == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToEmail must not be null");
        }
        Email email = EmailConverter.emlToEmailBuilder(eml, pkcs12Config).buildEmail();
        if (email == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToEmail must not return null");
        }
        return email;
    }

    @NotNull
    public static Email emlToEmail(@NotNull File emlFile) {
        if (emlFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToEmail must not be null");
        }
        Email email = EmailConverter.emlToEmail(emlFile, null);
        if (email == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToEmail must not return null");
        }
        return email;
    }

    @NotNull
    public static Email emlToEmail(@NotNull File emlFile, @Nullable Pkcs12Config pkcs12Config) {
        if (emlFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToEmail must not be null");
        }
        Email email = EmailConverter.emlToEmailBuilder(emlFile, pkcs12Config).buildEmail();
        if (email == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToEmail must not return null");
        }
        return email;
    }

    @NotNull
    public static EmailPopulatingBuilder emlToEmailBuilder(@NotNull File emlFile) {
        if (emlFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToEmailBuilder must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = EmailConverter.emlToEmailBuilder(emlFile, null);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToEmailBuilder must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public static EmailPopulatingBuilder emlToEmailBuilder(@NotNull File emlFile, @Nullable Pkcs12Config pkcs12Config) {
        if (emlFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToEmailBuilder must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = EmailConverter.mimeMessageToEmailBuilder(EmailConverter.emlToMimeMessage(emlFile), pkcs12Config);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToEmailBuilder must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public static EmailPopulatingBuilder emlToEmailBuilder(@NotNull InputStream emlInputStream) {
        if (emlInputStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToEmailBuilder must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = EmailConverter.emlToEmailBuilder(emlInputStream, null);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToEmailBuilder must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public static EmailPopulatingBuilder emlToEmailBuilder(@NotNull InputStream emlInputStream, @Nullable Pkcs12Config pkcs12Config) {
        EmailPopulatingBuilder emailPopulatingBuilder;
        if (emlInputStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToEmailBuilder must not be null");
        }
        try {
            String emlStr = MiscUtil.readInputStreamToString((InputStream)((InputStream)Preconditions.checkNonEmptyArgument((Object)emlInputStream, (String)"emlInputStream")), (Charset)StandardCharsets.UTF_8);
            emailPopulatingBuilder = EmailConverter.emlToEmailBuilder(emlStr, pkcs12Config);
        }
        catch (IOException e) {
            throw new EmailConverterException("Error reading EML string from given InputStream", e);
        }
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToEmailBuilder must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public static EmailPopulatingBuilder emlToEmailBuilder(@NotNull String eml) {
        if (eml == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToEmailBuilder must not be null");
        }
        EmailPopulatingBuilder emailPopulatingBuilder = EmailConverter.emlToEmailBuilder(eml, null);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToEmailBuilder must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public static EmailPopulatingBuilder emlToEmailBuilder(@NotNull String eml, @Nullable Pkcs12Config pkcs12Config) {
        if (eml == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToEmailBuilder must not be null");
        }
        MimeMessage mimeMessage = EmailConverter.emlToMimeMessage((String)Preconditions.checkNonEmptyArgument((Object)eml, (String)"eml"), EmailConverter.createDummySession());
        EmailPopulatingBuilder emailPopulatingBuilder = EmailConverter.mimeMessageToEmailBuilder(mimeMessage, pkcs12Config);
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToEmailBuilder must not return null");
        }
        return emailPopulatingBuilder;
    }

    @NotNull
    public static MimeMessage outlookMsgToMimeMessage(@NotNull String msgFile) {
        if (msgFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToMimeMessage must not be null");
        }
        MimeMessage mimeMessage = EmailConverter.outlookMsgToMimeMessage(msgFile, null);
        if (mimeMessage == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToMimeMessage must not return null");
        }
        return mimeMessage;
    }

    @NotNull
    public static MimeMessage outlookMsgToMimeMessage(@NotNull String msgData, @Nullable Pkcs12Config pkcs12Config) {
        if (msgData == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToMimeMessage must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)msgData, (String)"outlookMsgData");
        MimeMessage mimeMessage = EmailConverter.emailToMimeMessage(EmailConverter.outlookMsgToEmail(msgData, pkcs12Config));
        if (mimeMessage == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToMimeMessage must not return null");
        }
        return mimeMessage;
    }

    @NotNull
    public static MimeMessage outlookMsgToMimeMessage(@NotNull File outlookMsgFile) {
        if (outlookMsgFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToMimeMessage must not be null");
        }
        MimeMessage mimeMessage = EmailConverter.outlookMsgToMimeMessage(outlookMsgFile, null);
        if (mimeMessage == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToMimeMessage must not return null");
        }
        return mimeMessage;
    }

    @NotNull
    public static MimeMessage outlookMsgToMimeMessage(@NotNull File outlookMsgFile, @Nullable Pkcs12Config pkcs12Config) {
        if (outlookMsgFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToMimeMessage must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)outlookMsgFile, (String)"outlookMsgFile");
        MimeMessage mimeMessage = EmailConverter.emailToMimeMessage(EmailConverter.outlookMsgToEmail(outlookMsgFile, pkcs12Config));
        if (mimeMessage == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToMimeMessage must not return null");
        }
        return mimeMessage;
    }

    @NotNull
    public static MimeMessage outlookMsgToMimeMessage(@NotNull InputStream outlookMsgInputStream) {
        if (outlookMsgInputStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToMimeMessage must not be null");
        }
        MimeMessage mimeMessage = EmailConverter.outlookMsgToMimeMessage(outlookMsgInputStream, null);
        if (mimeMessage == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToMimeMessage must not return null");
        }
        return mimeMessage;
    }

    @NotNull
    public static MimeMessage outlookMsgToMimeMessage(@NotNull InputStream outlookMsgInputStream, @Nullable Pkcs12Config pkcs12Config) {
        if (outlookMsgInputStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToMimeMessage must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)outlookMsgInputStream, (String)"outlookMsgInputStream");
        MimeMessage mimeMessage = EmailConverter.emailToMimeMessage(EmailConverter.outlookMsgToEmail(outlookMsgInputStream, pkcs12Config));
        if (mimeMessage == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToMimeMessage must not return null");
        }
        return mimeMessage;
    }

    public static MimeMessage emailToMimeMessage(@NotNull Email email) {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emailToMimeMessage must not be null");
        }
        MimeMessage mimeMessage = EmailConverter.emailToMimeMessage((Email)Preconditions.checkNonEmptyArgument((Object)email, (String)"email"), EmailConverter.createDummySession());
        if (mimeMessage == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emailToMimeMessage must not return null");
        }
        return mimeMessage;
    }

    public static MimeMessage emailToMimeMessage(@NotNull Email email, @NotNull Session session) {
        MimeMessage mimeMessage;
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emailToMimeMessage must not be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/EmailConverter.emailToMimeMessage must not be null");
        }
        try {
            mimeMessage = MimeMessageProducerHelper.produceMimeMessage((Email)Preconditions.checkNonEmptyArgument((Object)email, (String)"email"), (Session)Preconditions.checkNonEmptyArgument((Object)session, (String)"session"));
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            throw new AssertionError(e.getMessage(), e);
        }
        if (mimeMessage == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emailToMimeMessage must not return null");
        }
        return mimeMessage;
    }

    @NotNull
    public static MimeMessage emlToMimeMessage(@NotNull File emlFile) {
        if (emlFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToMimeMessage must not be null");
        }
        MimeMessage mimeMessage = EmailConverter.emlToMimeMessage(emlFile, EmailConverter.createDummySession());
        if (mimeMessage == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToMimeMessage must not return null");
        }
        return mimeMessage;
    }

    public static MimeMessage emlToMimeMessage(@NotNull File emlFile, @NotNull Session session) {
        MimeMessage mimeMessage;
        if (emlFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToMimeMessage must not be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/EmailConverter.emlToMimeMessage must not be null");
        }
        if (!EML_PATH_MATCHER.matches(emlFile.toPath())) {
            throw new EmailConverterException(String.format("Eml file should have \".eml\" extension: %s", emlFile));
        }
        try {
            mimeMessage = EmailConverter.emlToMimeMessage(new FileInputStream((File)Preconditions.checkNonEmptyArgument((Object)emlFile, (String)"emlFile")), session);
        }
        catch (FileNotFoundException e) {
            throw new EmailConverterException(String.format("Error parsing EML data from file: %s", e.getMessage()), e);
        }
        if (mimeMessage == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToMimeMessage must not return null");
        }
        return mimeMessage;
    }

    @NotNull
    public static MimeMessage emlToMimeMessage(@NotNull InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToMimeMessage must not be null");
        }
        MimeMessage mimeMessage = EmailConverter.emlToMimeMessage(inputStream, EmailConverter.createDummySession());
        if (mimeMessage == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToMimeMessage must not return null");
        }
        return mimeMessage;
    }

    @NotNull
    public static MimeMessage emlToMimeMessage(@NotNull InputStream inputStream, @NotNull Session session) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToMimeMessage must not be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/EmailConverter.emlToMimeMessage must not be null");
        }
        try {
            MimeMessage mimeMessage = new MimeMessage(session, inputStream);
            if (mimeMessage == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToMimeMessage must not return null");
            }
            return mimeMessage;
        }
        catch (MessagingException e) {
            throw new EmailConverterException(String.format("Error parsing EML data from input stream: %s", e.getMessage()), (Exception)((Object)e));
        }
    }

    public static MimeMessage emlToMimeMessage(@NotNull String eml) {
        if (eml == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToMimeMessage must not be null");
        }
        MimeMessage mimeMessage = EmailConverter.emlToMimeMessage((String)Preconditions.checkNonEmptyArgument((Object)eml, (String)"eml"), EmailConverter.createDummySession());
        if (mimeMessage == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToMimeMessage must not return null");
        }
        return mimeMessage;
    }

    public static MimeMessage emlToMimeMessage(@NotNull String eml, @NotNull Session session) {
        if (eml == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emlToMimeMessage must not be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/EmailConverter.emlToMimeMessage must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)session, (String)"session");
        Preconditions.checkNonEmptyArgument((Object)eml, (String)"eml");
        try {
            MimeMessage mimeMessage = new MimeMessage(session, (InputStream)new ByteArrayInputStream(eml.getBytes(StandardCharsets.UTF_8)));
            if (mimeMessage == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emlToMimeMessage must not return null");
            }
            return mimeMessage;
        }
        catch (MessagingException e) {
            throw new EmailConverterException(String.format("Error parsing EML data from input stream: %s", e.getMessage()), (Exception)((Object)e));
        }
    }

    public static String mimeMessageToEML(@NotNull MimeMessage mimeMessage) {
        String string;
        if (mimeMessage == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.mimeMessageToEML must not be null");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ((MimeMessage)Preconditions.checkNonEmptyArgument((Object)mimeMessage, (String)"mimeMessage")).writeTo((OutputStream)os);
            string = os.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException | MessagingException e) {
            throw new AssertionError("This should never happen", e);
        }
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.mimeMessageToEML must not return null");
        }
        return string;
    }

    public static String emailToEML(@NotNull Email email) {
        if (email == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.emailToEML must not be null");
        }
        String string = EmailConverter.mimeMessageToEML(EmailConverter.emailToMimeMessage((Email)Preconditions.checkNonEmptyArgument((Object)email, (String)"email")));
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.emailToEML must not return null");
        }
        return string;
    }

    @NotNull
    public static String outlookMsgToEML(@NotNull String msgFile) {
        if (msgFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToEML must not be null");
        }
        String string = EmailConverter.outlookMsgToEML(msgFile, null);
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToEML must not return null");
        }
        return string;
    }

    @NotNull
    public static String outlookMsgToEML(@NotNull String msgData, @Nullable Pkcs12Config pkcs12Config) {
        if (msgData == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToEML must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)msgData, (String)"outlookMsgData");
        String string = EmailConverter.emailToEML(EmailConverter.outlookMsgToEmail(msgData, pkcs12Config));
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToEML must not return null");
        }
        return string;
    }

    @NotNull
    public static String outlookMsgToEML(@NotNull File outlookMsgFile) {
        if (outlookMsgFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToEML must not be null");
        }
        String string = EmailConverter.outlookMsgToEML(outlookMsgFile, null);
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToEML must not return null");
        }
        return string;
    }

    @NotNull
    public static String outlookMsgToEML(@NotNull File outlookMsgFile, @Nullable Pkcs12Config pkcs12Config) {
        if (outlookMsgFile == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToEML must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)outlookMsgFile, (String)"outlookMsgFile");
        String string = EmailConverter.emailToEML(EmailConverter.outlookMsgToEmail(outlookMsgFile, pkcs12Config));
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToEML must not return null");
        }
        return string;
    }

    @NotNull
    public static String outlookMsgToEML(@NotNull InputStream outlookMsgInputStream) {
        if (outlookMsgInputStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToEML must not be null");
        }
        String string = EmailConverter.outlookMsgToEML(outlookMsgInputStream, null);
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToEML must not return null");
        }
        return string;
    }

    @NotNull
    public static String outlookMsgToEML(@NotNull InputStream outlookMsgInputStream, @Nullable Pkcs12Config pkcs12Config) {
        if (outlookMsgInputStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.outlookMsgToEML must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)outlookMsgInputStream, (String)"outlookMsgInputStream");
        String string = EmailConverter.emailToEML(EmailConverter.outlookMsgToEmail(outlookMsgInputStream, pkcs12Config));
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.outlookMsgToEML must not return null");
        }
        return string;
    }

    private static EmailPopulatingBuilder buildEmailFromMimeMessage(@NotNull EmailPopulatingBuilder builder, @NotNull MimeMessageParser.ParsedMimeMessageComponents parsed) {
        InternetAddress bTo;
        InternetAddress rrTo;
        if (builder == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/converter/EmailConverter.buildEmailFromMimeMessage must not be null");
        }
        if (parsed == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/converter/EmailConverter.buildEmailFromMimeMessage must not be null");
        }
        Preconditions.checkNonEmptyArgument((Object)builder, (String)"emailBuilder");
        Preconditions.checkNonEmptyArgument((Object)parsed, (String)"parsedMimeMessageComponents");
        if (parsed.getSentDate() != null) {
            builder.fixingSentDate(parsed.getSentDate());
        }
        if (parsed.getFromAddress() != null) {
            builder.from(parsed.getFromAddress().getPersonal(), parsed.getFromAddress().getAddress());
        }
        if (parsed.getReplyToAddresses() != null) {
            builder.withReplyTo(parsed.getReplyToAddresses().getPersonal(), parsed.getReplyToAddresses().getAddress());
        }
        builder.withHeaders(parsed.getHeaders());
        InternetAddress dnTo = parsed.getDispositionNotificationTo();
        if (dnTo != null) {
            builder.withDispositionNotificationTo(dnTo);
        }
        if ((rrTo = parsed.getReturnReceiptTo()) != null) {
            builder.withReturnReceiptTo(rrTo);
        }
        if ((bTo = parsed.getBounceToAddress()) != null) {
            builder.withBounceTo(bTo);
        }
        builder.fixingMessageId(parsed.getMessageId());
        for (InternetAddress internetAddress : parsed.getToAddresses()) {
            builder.to(internetAddress);
        }
        for (InternetAddress internetAddress : parsed.getCcAddresses()) {
            builder.cc(internetAddress);
        }
        for (InternetAddress internetAddress : parsed.getBccAddresses()) {
            builder.bcc(internetAddress);
        }
        builder.withSubject(parsed.getSubject() != null ? parsed.getSubject() : "");
        builder.withPlainText(parsed.getPlainContent());
        builder.withHTMLText(parsed.getHtmlContent());
        if (parsed.getCalendarMethod() != null) {
            builder.withCalendarText(CalendarMethod.valueOf((String)parsed.getCalendarMethod()), (String)Preconditions.assumeNonNull((Object)parsed.getCalendarContent()));
        }
        for (Map.Entry entry : parsed.getCidMap().entrySet()) {
            String cidName = (String)Preconditions.checkNonEmptyArgument(entry.getKey(), (String)"cid.key");
            builder.withEmbeddedImage(MiscUtil.extractCID((String)cidName), (DataSource)entry.getValue());
        }
        for (Map.Entry entry : parsed.getAttachmentList()) {
            builder.withAttachment(MiscUtil.extractCID((String)((String)entry.getKey())), (DataSource)entry.getValue());
        }
        EmailPopulatingBuilder emailPopulatingBuilder = builder;
        if (emailPopulatingBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.buildEmailFromMimeMessage must not return null");
        }
        return emailPopulatingBuilder;
    }

    private static Session createDummySession() {
        Session session = Session.getDefaultInstance((Properties)new Properties());
        if (session == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/converter/EmailConverter.createDummySession must not return null");
        }
        return session;
    }
}

