/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.simplejavamail.internal.util.MiscUtil;

public class ServerConfig {
    private final String host;
    private final Integer port;
    private final String username;
    private final String password;

    ServerConfig(@Nonnull String host, @Nonnull Integer port, @Nullable String username, @Nullable String password) {
        this.host = MiscUtil.checkArgumentNotEmpty(host, "smtp host address not given and not configured in config file");
        this.port = MiscUtil.checkArgumentNotEmpty(port, "smtp host port not given and not configured in config file");
        this.username = username;
        this.password = password;
        if (MiscUtil.valueNullOrEmpty(this.username) && !MiscUtil.valueNullOrEmpty(this.password)) {
            throw new IllegalArgumentException("Password provided but no username given as argument or in config file");
        }
    }

    public String toString() {
        String str = String.format("%s:%s", this.host, this.port);
        if (this.username != null) {
            str = str + String.format(", username: %s", this.username);
        }
        if (this.password != null) {
            str = str + " (authenticated)";
        }
        return str;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

