/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.mailer.internal.mailsender.OperationalConfig;
import org.simplejavamail.mailer.internal.mailsender.ProxyConfig;
import org.simplejavamail.util.ConfigLoader;

public abstract class MailerGenericBuilder<T extends MailerGenericBuilder> {
    public static final int DEFAULT_SESSION_TIMEOUT_MILLIS = 60000;
    public static final int DEFAULT_POOL_SIZE = 10;
    public static final int DEFAULT_PROXY_BRIDGE_PORT = 1081;
    public static final boolean DEFAULT_TRANSPORT_MODE_LOGGING_ONLY = false;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private Integer proxyBridgePort;
    private Boolean debugLogging;
    private Integer sessionTimeout;
    private EnumSet<EmailAddressCriteria> emailAddressCriteria;
    private Integer threadPoolSize;
    private List<String> sslHostsToTrust = new ArrayList<String>();
    private Boolean trustAllSSLHost;
    private Properties properties = new Properties();
    private Boolean transportModeLoggingOnly;

    MailerGenericBuilder() {
        if (ConfigLoader.hasProperty(ConfigLoader.Property.PROXY_HOST)) {
            this.withProxyHost(ConfigLoader.getStringProperty(ConfigLoader.Property.PROXY_HOST));
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.PROXY_PORT)) {
            this.withProxyPort(ConfigLoader.getIntegerProperty(ConfigLoader.Property.PROXY_PORT));
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.PROXY_USERNAME)) {
            this.withProxyUsername(ConfigLoader.getStringProperty(ConfigLoader.Property.PROXY_USERNAME));
        }
        if (ConfigLoader.hasProperty(ConfigLoader.Property.PROXY_PASSWORD)) {
            this.withProxyPassword(ConfigLoader.getStringProperty(ConfigLoader.Property.PROXY_PASSWORD));
        }
        this.withProxyBridgePort(ConfigLoader.valueOrPropertyAsInteger(null, ConfigLoader.Property.PROXY_SOCKS5BRIDGE_PORT, 1081));
        this.withDebugLogging(ConfigLoader.valueOrPropertyAsBoolean(null, ConfigLoader.Property.JAVAXMAIL_DEBUG, false));
        this.withSessionTimeout(ConfigLoader.valueOrPropertyAsInteger(null, ConfigLoader.Property.DEFAULT_SESSION_TIMEOUT_MILLIS, 60000));
        this.withThreadPoolSize(ConfigLoader.valueOrPropertyAsInteger(null, ConfigLoader.Property.DEFAULT_POOL_SIZE, 10));
        this.withTransportModeLoggingOnly(ConfigLoader.valueOrPropertyAsBoolean(null, ConfigLoader.Property.TRANSPORT_MODE_LOGGING_ONLY, false));
        this.withEmailAddressCriteria(EmailAddressCriteria.RFC_COMPLIANT);
        this.trustingAllHosts(true);
    }

    ProxyConfig buildProxyConfig() {
        this.validateProxy();
        return new ProxyConfig(this.getProxyHost(), this.getProxyPort(), this.getProxyUsername(), this.getProxyPassword(), this.getProxyBridgePort());
    }

    private void validateProxy() {
        if (!MiscUtil.valueNullOrEmpty(this.proxyHost)) {
            MiscUtil.checkArgumentNotEmpty(this.proxyPort, "proxyHost provided, but not a proxyPort");
            if (!MiscUtil.valueNullOrEmpty(this.proxyUsername) && MiscUtil.valueNullOrEmpty(this.proxyPassword)) {
                throw new IllegalArgumentException("Proxy username provided but not a password");
            }
            if (MiscUtil.valueNullOrEmpty(this.proxyUsername) && !MiscUtil.valueNullOrEmpty(this.proxyPassword)) {
                throw new IllegalArgumentException("Proxy password provided but not a username");
            }
        }
    }

    OperationalConfig buildOperationalConfig() {
        return new OperationalConfig(this.getProperties(), this.getSessionTimeout(), this.getThreadPoolSize(), this.getTransportModeLoggingOnly(), this.getDebugLogging(), this.getSslHostsToTrust(), this.getTrustAllSSLHost());
    }

    public T withProxy(@Nullable String proxyHost, @Nullable Integer proxyPort) {
        return ((MailerGenericBuilder)this.withProxyHost(proxyHost)).withProxyPort(proxyPort);
    }

    public T withProxy(@Nullable String proxyHost, @Nullable Integer proxyPort, @Nullable String proxyUsername, @Nullable String proxyPassword) {
        return ((MailerGenericBuilder)((MailerGenericBuilder)((MailerGenericBuilder)this.withProxyHost(proxyHost)).withProxyPort(proxyPort)).withProxyUsername(proxyUsername)).withProxyPassword(proxyPassword);
    }

    public T withProxyHost(@Nullable String proxyHost) {
        this.proxyHost = proxyHost;
        return (T)this;
    }

    public T withProxyPort(@Nullable Integer proxyPort) {
        this.proxyPort = proxyPort;
        return (T)this;
    }

    public T withProxyUsername(@Nullable String proxyUsername) {
        this.proxyUsername = proxyUsername;
        return (T)this;
    }

    public T withProxyPassword(@Nullable String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return (T)this;
    }

    public T withProxyBridgePort(@Nullable Integer proxyBridgePort) {
        this.proxyBridgePort = proxyBridgePort;
        return (T)this;
    }

    public T withDebugLogging(@Nullable Boolean debugLogging) {
        this.debugLogging = debugLogging;
        return (T)this;
    }

    public T withSessionTimeout(@Nullable Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return (T)this;
    }

    public T withEmailAddressCriteria(@Nonnull EnumSet<EmailAddressCriteria> emailAddressCriteria) {
        this.emailAddressCriteria = emailAddressCriteria.clone();
        return (T)this;
    }

    public T withThreadPoolSize(@Nonnull Integer defaultPoolSize) {
        this.threadPoolSize = defaultPoolSize;
        return (T)this;
    }

    public T withTransportModeLoggingOnly(@Nonnull Boolean transportModeLoggingOnly) {
        this.transportModeLoggingOnly = transportModeLoggingOnly;
        return (T)this;
    }

    public T trustingSSLHosts(String ... sslHostsToTrust) {
        this.sslHostsToTrust = Arrays.asList(sslHostsToTrust);
        return (T)this;
    }

    public T trustingAllHosts(@Nonnull Boolean trustAllHosts) {
        this.trustAllSSLHost = trustAllHosts;
        return (T)this;
    }

    public T withProperties(@Nonnull Properties properties) {
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            this.properties.put(property.getKey(), property.getValue());
        }
        return (T)this;
    }

    public T withProperties(@Nonnull Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            this.properties.put(property.getKey(), property.getValue());
        }
        return (T)this;
    }

    public T withProperty(@Nonnull String propertyName, @Nullable String propertyValue) {
        if (propertyValue == null) {
            this.properties.remove(propertyName);
        } else {
            this.properties.put(propertyName, propertyValue);
        }
        return (T)this;
    }

    public T resetSessionTimeout() {
        return this.withSessionTimeout(60000);
    }

    public T resetEmailAddressCriteria() {
        return this.withEmailAddressCriteria(EmailAddressCriteria.RFC_COMPLIANT);
    }

    public T resetThreadpoolSize() {
        return this.withThreadPoolSize(10);
    }

    public T resetTransportModeLoggingOnly() {
        return this.withTransportModeLoggingOnly(false);
    }

    public T clearProxy() {
        return ((MailerGenericBuilder)this.withProxy(null, null, null, null)).withProxyBridgePort(null);
    }

    public T clearEmailAddressCriteria() {
        return this.withEmailAddressCriteria(EnumSet.noneOf(EmailAddressCriteria.class));
    }

    public T clearTrustedSSLHosts() {
        return this.trustingSSLHosts(new String[0]);
    }

    public T clearProperties() {
        this.properties.clear();
        return (T)this;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public Integer getProxyBridgePort() {
        return this.proxyBridgePort;
    }

    public Boolean getDebugLogging() {
        return this.debugLogging;
    }

    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    public EnumSet<EmailAddressCriteria> getEmailAddressCriteria() {
        return this.emailAddressCriteria;
    }

    public Integer getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public List<String> getSslHostsToTrust() {
        return this.sslHostsToTrust;
    }

    public Boolean getTrustAllSSLHost() {
        return this.trustAllSSLHost;
    }

    public boolean getTransportModeLoggingOnly() {
        return this.transportModeLoggingOnly;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

