/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.email;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Message;
import org.simplejavamail.internal.util.Preconditions;

public final class Recipient {
    @Nullable
    private final String name;
    @Nonnull
    private final String address;
    @Nullable
    private final Message.RecipientType type;

    public Recipient(@Nullable String name, @Nonnull String address, @Nullable Message.RecipientType type) {
        this.name = name;
        this.address = Preconditions.checkNonEmptyArgument(address, "address");
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipient recipient = (Recipient)o;
        return Objects.equals(this.name, recipient.name) && Objects.equals(this.address, recipient.address) && Objects.equals(this.type, recipient.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.address, this.type);
    }

    @Nonnull
    public String toString() {
        return "Recipient{name='" + this.name + '\'' + ", address='" + this.address + '\'' + ", type=" + this.type + '}';
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getAddress() {
        return this.address;
    }

    @Nullable
    public Message.RecipientType getType() {
        return this.type;
    }
}

