/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.email;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.simplejavamail.converter.EmailConverter;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageParser;
import org.simplejavamail.email.Email;
import org.simplejavamail.email.EmailException;
import org.simplejavamail.email.EmailPopulatingBuilder;
import org.simplejavamail.internal.util.MiscUtil;

public class EmailBuilder {
    public static EmailBuilderInstance ignoringDefaults() {
        return new EmailBuilderInstance().ignoringDefaults();
    }

    public static EmailPopulatingBuilder replyingTo(@Nonnull Email email) {
        return new EmailBuilderInstance().replyingTo(email);
    }

    public static EmailPopulatingBuilder replyingToAll(@Nonnull Email email) {
        return new EmailBuilderInstance().replyingToAll(email);
    }

    public static EmailPopulatingBuilder replyingToAll(@Nonnull Email email, @Nonnull String customQuotingTemplate) {
        return new EmailBuilderInstance().replyingToAll(email, customQuotingTemplate);
    }

    public static EmailPopulatingBuilder replyingTo(@Nonnull Email email, @Nonnull String customQuotingTemplate) {
        return new EmailBuilderInstance().replyingTo(email, customQuotingTemplate);
    }

    public static EmailPopulatingBuilder replyingTo(@Nonnull MimeMessage email) {
        return new EmailBuilderInstance().replyingTo(email);
    }

    public static EmailPopulatingBuilder replyingToAll(@Nonnull MimeMessage email, @Nonnull String customQuotingTemplate) {
        return new EmailBuilderInstance().replyingToAll(email, customQuotingTemplate);
    }

    public static EmailPopulatingBuilder replyingTo(@Nonnull MimeMessage email, @Nonnull String customQuotingTemplate) {
        return new EmailBuilderInstance().replyingTo(email, customQuotingTemplate);
    }

    public static EmailPopulatingBuilder replyingToAll(@Nonnull MimeMessage email) {
        return new EmailBuilderInstance().replyingToAll(email);
    }

    public static EmailPopulatingBuilder replyingTo(@Nonnull MimeMessage emailMessage, boolean repyToAll, @Nonnull String htmlTemplate) {
        return new EmailBuilderInstance().replyingTo(emailMessage, repyToAll, htmlTemplate);
    }

    public static EmailPopulatingBuilder forwarding(@Nonnull Email email) {
        return new EmailBuilderInstance().forwarding(email);
    }

    public static EmailPopulatingBuilder forwarding(@Nonnull MimeMessage emailMessage) {
        return new EmailBuilderInstance().forwarding(emailMessage);
    }

    public static EmailPopulatingBuilder copying(@Nonnull MimeMessage message) {
        return new EmailBuilderInstance().copying(message);
    }

    public static EmailPopulatingBuilder copying(@Nonnull EmailPopulatingBuilder emailBuilder) {
        return new EmailBuilderInstance().copying(emailBuilder);
    }

    public static EmailPopulatingBuilder copying(@Nonnull Email email) {
        return new EmailBuilderInstance().copying(email);
    }

    public static EmailPopulatingBuilder startingBlank() {
        return new EmailBuilderInstance().startingBlank();
    }

    private EmailBuilder() {
    }

    public static final class EmailBuilderInstance {
        static final Pattern LINE_START_PATTERN = Pattern.compile("(?m)^");
        static final String DEFAULT_QUOTING_MARKUP = "<blockquote style=\"color: gray; border-left: 1px solid #4f4f4f; padding-left: 1cm\">%s</blockquote>";
        private boolean applyDefaults = true;

        private EmailBuilderInstance() {
        }

        EmailBuilderInstance ignoringDefaults() {
            this.applyDefaults = false;
            return this;
        }

        public EmailPopulatingBuilder startingBlank() {
            return new EmailPopulatingBuilder(this.applyDefaults);
        }

        public EmailPopulatingBuilder replyingTo(@Nonnull Email email) {
            return this.replyingTo(EmailConverter.emailToMimeMessage(email), false, DEFAULT_QUOTING_MARKUP);
        }

        public EmailPopulatingBuilder replyingToAll(@Nonnull Email email) {
            return this.replyingTo(EmailConverter.emailToMimeMessage(email), true, DEFAULT_QUOTING_MARKUP);
        }

        public EmailPopulatingBuilder replyingToAll(@Nonnull Email email, @Nonnull String customQuotingTemplate) {
            return this.replyingTo(EmailConverter.emailToMimeMessage(email), true, customQuotingTemplate);
        }

        public EmailPopulatingBuilder replyingTo(@Nonnull Email email, @Nonnull String customQuotingTemplate) {
            return this.replyingTo(EmailConverter.emailToMimeMessage(email), false, customQuotingTemplate);
        }

        public EmailPopulatingBuilder replyingTo(@Nonnull MimeMessage email) {
            return this.replyingTo(email, false, DEFAULT_QUOTING_MARKUP);
        }

        public EmailPopulatingBuilder replyingToAll(@Nonnull MimeMessage email, @Nonnull String customQuotingTemplate) {
            return this.replyingTo(email, true, customQuotingTemplate);
        }

        public EmailPopulatingBuilder replyingTo(@Nonnull MimeMessage email, @Nonnull String customQuotingTemplate) {
            return this.replyingTo(email, false, customQuotingTemplate);
        }

        public EmailPopulatingBuilder replyingToAll(@Nonnull MimeMessage email) {
            return this.replyingTo(email, true, DEFAULT_QUOTING_MARKUP);
        }

        public EmailPopulatingBuilder replyingTo(@Nonnull MimeMessage emailMessage, boolean repyToAll, @Nonnull String htmlTemplate) {
            MimeMessage replyMessage;
            try {
                replyMessage = (MimeMessage)emailMessage.reply(repyToAll);
                replyMessage.setText("ignore");
                replyMessage.setFrom("ignore@ignore.ignore");
            }
            catch (MessagingException e) {
                throw new EmailException("was unable to parse mimemessage to produce a reply for", (Exception)((Object)e));
            }
            Email repliedTo = EmailConverter.mimeMessageToEmail(emailMessage);
            Email generatedReply = EmailConverter.mimeMessageToEmail(replyMessage);
            return this.startingBlank().withSubject(generatedReply.getSubject()).to(generatedReply.getRecipients()).withPlainText(LINE_START_PATTERN.matcher(MiscUtil.defaultTo(repliedTo.getPlainText(), "")).replaceAll("> ")).withHTMLText(String.format(htmlTemplate, MiscUtil.defaultTo(repliedTo.getHTMLText(), ""))).withHeaders(generatedReply.getHeaders()).withEmbeddedImages(repliedTo.getEmbeddedImages());
        }

        public EmailPopulatingBuilder forwarding(@Nonnull Email email) {
            return this.forwarding(EmailConverter.emailToMimeMessage(email));
        }

        public EmailPopulatingBuilder forwarding(@Nonnull MimeMessage emailMessage) {
            return this.startingBlank().withForward(emailMessage).withSubject("Fwd: " + MimeMessageParser.parseSubject(emailMessage));
        }

        public EmailPopulatingBuilder copying(@Nonnull MimeMessage message) {
            return this.copying(EmailConverter.mimeMessageToEmail(message));
        }

        public EmailPopulatingBuilder copying(@Nonnull EmailPopulatingBuilder emailBuilder) {
            return this.copying(emailBuilder.buildEmail());
        }

        public EmailPopulatingBuilder copying(@Nonnull Email email) {
            EmailPopulatingBuilder builder = new EmailPopulatingBuilder(this.applyDefaults);
            if (email.getId() != null) {
                builder.fixingMessageId(email.getId());
            }
            if (email.getFromRecipient() != null) {
                builder.from(email.getFromRecipient());
            }
            if (email.getReplyToRecipient() != null) {
                builder.withReplyTo(email.getReplyToRecipient());
            }
            if (email.getBounceToRecipient() != null) {
                builder.withBounceTo(email.getBounceToRecipient());
            }
            if (email.getPlainText() != null) {
                builder.withPlainText(email.getPlainText());
            }
            if (email.getHTMLText() != null) {
                builder.withHTMLText(email.getHTMLText());
            }
            if (email.getSubject() != null) {
                builder.withSubject(email.getSubject());
            }
            if (email.getRecipients() != null) {
                builder.withRecipients(email.getRecipients());
            }
            if (email.getEmbeddedImages() != null) {
                builder.withEmbeddedImages(email.getEmbeddedImages());
            }
            if (email.getAttachments() != null) {
                builder.withAttachments(email.getAttachments());
            }
            if (email.getHeaders() != null) {
                builder.withHeaders(email.getHeaders());
            }
            if (email.getDkimPrivateKeyFile() != null) {
                builder.signWithDomainKey(email.getDkimPrivateKeyFile(), email.getDkimSigningDomain(), email.getDkimSelector());
            }
            if (email.getDkimPrivateKeyInputStream() != null) {
                builder.signWithDomainKey(email.getDkimPrivateKeyInputStream(), email.getDkimSigningDomain(), email.getDkimSelector());
            }
            if (email.getDispositionNotificationTo() != null) {
                builder.withDispositionNotificationTo(email.getDispositionNotificationTo());
            }
            if (email.getReturnReceiptTo() != null) {
                builder.withReturnReceiptTo(email.getReturnReceiptTo());
            }
            if (email.getEmailToForward() != null) {
                builder.withForward(email.getEmailToForward());
            }
            return builder;
        }
    }
}

