/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.markenwerk.utils.mail.dkim.Canonicalization;
import net.markenwerk.utils.mail.dkim.DkimMessage;
import net.markenwerk.utils.mail.dkim.DkimSigner;
import net.markenwerk.utils.mail.dkim.SigningAlgorithm;
import org.simplejavamail.converter.internal.mimemessage.IDKIMSigner;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageParseException;
import org.simplejavamail.email.Email;

public class DKIMSigner
implements IDKIMSigner {
    @Override
    public MimeMessage signMessageWithDKIM(MimeMessage messageToSign, Email emailContainingSigningDetails) {
        try {
            DkimSigner dkimSigner = emailContainingSigningDetails.getDkimPrivateKeyFile() != null ? new DkimSigner(emailContainingSigningDetails.getDkimSigningDomain(), emailContainingSigningDetails.getDkimSelector(), emailContainingSigningDetails.getDkimPrivateKeyFile()) : new DkimSigner(emailContainingSigningDetails.getDkimSigningDomain(), emailContainingSigningDetails.getDkimSelector(), emailContainingSigningDetails.getDkimPrivateKeyInputStream());
            dkimSigner.setIdentity(emailContainingSigningDetails.getFromRecipient().getAddress());
            dkimSigner.setHeaderCanonicalization(Canonicalization.SIMPLE);
            dkimSigner.setBodyCanonicalization(Canonicalization.RELAXED);
            dkimSigner.setSigningAlgorithm(SigningAlgorithm.SHA256_WITH_RSA);
            dkimSigner.setLengthParam(true);
            dkimSigner.setZParam(false);
            return new DkimMessage(messageToSign, dkimSigner);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException | MessagingException e) {
            throw new MimeMessageParseException("Error signing MimeMessage with DKIM", (Exception)e);
        }
    }
}

