/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.batchsupport;

import jakarta.mail.Session;
import java.util.concurrent.TimeUnit;
import org.bbottema.clusteredobjectpool.core.ClusterConfig;
import org.bbottema.clusteredobjectpool.core.api.LoadBalancingStrategy;
import org.bbottema.clusteredobjectpool.cyclingstrategies.RandomAccessLoadBalancing;
import org.bbottema.clusteredobjectpool.cyclingstrategies.RoundRobinLoadBalancing;
import org.bbottema.genericobjectpool.ExpirationPolicy;
import org.bbottema.genericobjectpool.expirypolicies.TimeoutSinceLastAllocationExpirationPolicy;
import org.bbottema.genericobjectpool.util.Timeout;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.mailer.config.OperationalConfig;
import org.simplejavamail.smtpconnectionpool.SessionTransport;
import org.simplejavamail.smtpconnectionpool.SmtpClusterConfig;

final class ClusterHelper {
    private ClusterHelper() {
    }

    @NotNull
    static SmtpClusterConfig configureSmtpClusterConfig(@NotNull OperationalConfig operationalConfig) {
        SmtpClusterConfig smtpClusterConfig = new SmtpClusterConfig();
        smtpClusterConfig.getConfigBuilder().defaultCorePoolSize(operationalConfig.getConnectionPoolCoreSize()).defaultMaxPoolSize(operationalConfig.getConnectionPoolMaxSize()).claimTimeout(new Timeout((long)operationalConfig.getConnectionPoolClaimTimeoutMillis(), TimeUnit.MILLISECONDS)).loadBalancingStrategy((LoadBalancingStrategy)(operationalConfig.getConnectionPoolLoadBalancingStrategy() == org.simplejavamail.api.mailer.config.LoadBalancingStrategy.ROUND_ROBIN ? new RoundRobinLoadBalancing() : new RandomAccessLoadBalancing())).defaultExpirationPolicy((ExpirationPolicy)new TimeoutSinceLastAllocationExpirationPolicy((long)operationalConfig.getConnectionPoolExpireAfterMillis(), TimeUnit.MILLISECONDS));
        return smtpClusterConfig;
    }

    static boolean compareClusterConfig(@NotNull OperationalConfig operationalConfig, ClusterConfig<Session, SessionTransport> config) {
        return config.getDefaultCorePoolSize() != operationalConfig.getConnectionPoolCoreSize() || config.getDefaultMaxPoolSize() != operationalConfig.getConnectionPoolMaxSize() || config.getLoadBalancingStrategy().getClass() != ClusterHelper.determineLoadBalancingStrategy(operationalConfig).getClass() || !config.getDefaultExpirationPolicy().equals(new TimeoutSinceLastAllocationExpirationPolicy((long)operationalConfig.getConnectionPoolExpireAfterMillis(), TimeUnit.MILLISECONDS));
    }

    @NotNull
    private static LoadBalancingStrategy determineLoadBalancingStrategy(@NotNull OperationalConfig operationalConfig) {
        return operationalConfig.getConnectionPoolLoadBalancingStrategy() == org.simplejavamail.api.mailer.config.LoadBalancingStrategy.ROUND_ROBIN ? new RoundRobinLoadBalancing() : new RandomAccessLoadBalancing();
    }
}

