/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.authenticatedsockssupport.socks5client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.simplejavamail.internal.authenticatedsockssupport.common.SocksException;
import org.simplejavamail.internal.authenticatedsockssupport.socks5client.ProxyCredentials;
import org.simplejavamail.internal.authenticatedsockssupport.socks5client.Socks5;
import org.simplejavamail.internal.util.MiscUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SocksAuthenticationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocksAuthenticationHelper.class);
    private static final byte SOCKS_VERSION = 5;
    private static final int ACCEPTABLE_METHODS = 2;
    private static final int NO_AUTHENTICATION_REQUIRED_METHOD = 0;
    private static final int USERNAME_PASSWORD_METHOD = 2;

    SocksAuthenticationHelper() {
    }

    public static boolean shouldAuthenticate(Socket socket) throws IOException {
        byte[] bufferSent = new byte[]{5, 2, 0, 2};
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write(bufferSent);
        outputStream.flush();
        LOGGER.trace("{}", (Object)MiscUtil.buildLogStringForSOCKSCommunication((byte[])bufferSent, (boolean)false));
        InputStream inputStream = socket.getInputStream();
        byte[] receivedData = SocksAuthenticationHelper.read2Bytes(inputStream);
        LOGGER.trace("{}", (Object)MiscUtil.buildLogStringForSOCKSCommunication((byte[])receivedData, (boolean)true));
        if (receivedData[0] != 5) {
            throw new SocksException("Remote server don't support SOCKS5");
        }
        byte command = receivedData[1];
        if (command != 0 && command != 2) {
            throw new SocksException("requested authentication method not supported: " + command);
        }
        return command == 2;
    }

    public static void performUserPasswordAuthentication(Socks5 socksProxy) throws IOException {
        MiscUtil.checkNotNull((Object)socksProxy, (String)"Argument [socksProxy] may not be null");
        ProxyCredentials credentials = socksProxy.getCredentials();
        if (credentials == null) {
            throw new SocksException("Need Username/Password authentication");
        }
        String username = credentials.getUsername();
        String password = credentials.getPassword();
        InputStream inputStream = socksProxy.getInputStream();
        OutputStream outputStream = socksProxy.getOutputStream();
        int USERNAME_LENGTH = username.getBytes(StandardCharsets.UTF_8).length;
        int PASSWORD_LENGTH = password.getBytes(StandardCharsets.UTF_8).length;
        byte[] bytesOfUsername = username.getBytes(StandardCharsets.UTF_8);
        byte[] bytesOfPassword = password.getBytes(StandardCharsets.UTF_8);
        byte[] bufferSent = new byte[3 + USERNAME_LENGTH + PASSWORD_LENGTH];
        bufferSent[0] = 1;
        bufferSent[1] = (byte)USERNAME_LENGTH;
        System.arraycopy(bytesOfUsername, 0, bufferSent, 2, USERNAME_LENGTH);
        bufferSent[2 + USERNAME_LENGTH] = (byte)PASSWORD_LENGTH;
        System.arraycopy(bytesOfPassword, 0, bufferSent, 3 + USERNAME_LENGTH, PASSWORD_LENGTH);
        outputStream.write(bufferSent);
        outputStream.flush();
        LOGGER.trace("{}", (Object)MiscUtil.buildLogStringForSOCKSCommunication((byte[])bufferSent, (boolean)false));
        byte[] authenticationResult = new byte[2];
        SocksAuthenticationHelper.checkEnd(inputStream.read(authenticationResult));
        LOGGER.trace("{}", (Object)MiscUtil.buildLogStringForSOCKSCommunication((byte[])authenticationResult, (boolean)true));
        if (authenticationResult[1] != 0) {
            outputStream.close();
            inputStream.close();
            socksProxy.getProxySocket().close();
            throw new SocksException("Username or password error");
        }
    }

    private static byte[] read2Bytes(InputStream inputStream) throws IOException {
        byte[] bytes = new byte[]{(byte)SocksAuthenticationHelper.checkEnd(inputStream.read()), (byte)SocksAuthenticationHelper.checkEnd(inputStream.read())};
        return bytes;
    }

    private static int checkEnd(int b) throws IOException {
        if (b < 0) {
            throw new IOException("End of stream");
        }
        return b;
    }
}

