/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport.connect;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.simpleframework.transport.Server;
import org.simpleframework.transport.SocketWrapper;
import org.simpleframework.transport.connect.ConnectionEvent;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.transport.trace.Agent;
import org.simpleframework.transport.trace.Trace;

class SocketAcceptor
implements Operation {
    private final ServerSocketChannel listener = ServerSocketChannel.open();
    private final ServerSocket socket = this.listener.socket();
    private final SSLContext context;
    private final Server server;
    private final Agent agent;

    public SocketAcceptor(SocketAddress address, SSLContext context, Server server, Agent agent) throws IOException {
        this.context = context;
        this.agent = agent;
        this.server = server;
        this.bind(address);
    }

    public SocketAddress getAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public SelectableChannel getChannel() {
        return this.listener;
    }

    public void run() {
        try {
            this.accept();
        }
        catch (Exception e) {
            this.pause();
        }
    }

    private void pause() {
        try {
            Thread.sleep(10L);
        }
        catch (Exception e) {
            return;
        }
    }

    public void cancel() {
        try {
            this.close();
        }
        finally {
            return;
        }
    }

    private void bind(SocketAddress address) throws IOException {
        this.listener.configureBlocking(false);
        this.socket.setReuseAddress(true);
        this.socket.bind(address, 100);
    }

    private void accept() throws IOException {
        SocketChannel channel = this.listener.accept();
        while (channel != null) {
            Trace trace = this.agent.attach(channel);
            this.configure(channel);
            if (this.context == null) {
                this.process(channel, trace, null);
            } else {
                this.process(channel, trace);
            }
            channel = this.listener.accept();
        }
    }

    private void configure(SocketChannel channel) throws IOException {
        channel.socket().setTcpNoDelay(true);
        channel.configureBlocking(false);
    }

    private void process(SocketChannel channel, Trace trace) throws IOException {
        SSLEngine engine = this.context.createSSLEngine();
        try {
            this.process(channel, trace, engine);
        }
        catch (Exception cause) {
            trace.trace((Object)ConnectionEvent.ERROR, cause);
            channel.close();
        }
    }

    private void process(SocketChannel channel, Trace trace, SSLEngine engine) throws IOException {
        SocketWrapper socket = new SocketWrapper(channel, trace, engine);
        try {
            trace.trace((Object)ConnectionEvent.ACCEPT);
            this.server.process(socket);
        }
        catch (Exception cause) {
            trace.trace((Object)ConnectionEvent.ERROR, cause);
            channel.close();
        }
    }

    public void close() throws IOException {
        this.listener.close();
    }
}

