/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.core.ObjectScanner;
import org.simpleframework.xml.core.PrimitiveScanner;
import org.simpleframework.xml.core.Scanner;
import org.simpleframework.xml.core.Support;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.util.Cache;
import org.simpleframework.xml.util.ConcurrentCache;

class ScannerFactory {
    private final Cache<Scanner> cache = new ConcurrentCache<Scanner>();
    private final Support support;
    private final Format format;

    public ScannerFactory(Support support, Format format) {
        this.support = support;
        this.format = format;
    }

    public Scanner getInstance(Class type) throws Exception {
        Scanner schema = this.cache.fetch(type);
        if (schema == null) {
            schema = this.support.isPrimitive(type) ? new PrimitiveScanner(type) : new ObjectScanner(type, this.format);
            this.cache.cache(type, schema);
        }
        return schema;
    }
}

