/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.core.Expression;
import org.simpleframework.xml.core.Introspector;
import org.simpleframework.xml.core.Primitive;
import org.simpleframework.xml.core.TemplateLabel;
import org.simpleframework.xml.core.TextException;
import org.simpleframework.xml.stream.Format;

class TextLabel
extends TemplateLabel {
    private Introspector detail;
    private Expression path;
    private Contact contact;
    private Text label;
    private Class type;
    private String empty;

    public TextLabel(Contact contact, Text label, Format format) {
        this.detail = new Introspector(contact, this, format);
        this.type = contact.getType();
        this.empty = label.empty();
        this.contact = contact;
        this.label = label;
    }

    public Decorator getDecorator() throws Exception {
        return null;
    }

    public Converter getConverter(Context context) throws Exception {
        String ignore = this.getEmpty(context);
        Contact type = this.getContact();
        if (!context.isPrimitive(type)) {
            throw new TextException("Cannot use %s to represent %s", type, this.label);
        }
        return new Primitive(context, type, ignore);
    }

    public String getEmpty(Context context) {
        if (this.detail.isEmpty(this.empty)) {
            return null;
        }
        return this.empty;
    }

    public String getPath() throws Exception {
        return this.getExpression().getPath();
    }

    public Expression getExpression() throws Exception {
        if (this.path == null) {
            this.path = this.detail.getExpression();
        }
        return this.path;
    }

    public Annotation getAnnotation() {
        return this.label;
    }

    public Contact getContact() {
        return this.contact;
    }

    public String getName() {
        return "";
    }

    public String getOverride() {
        return ((Object)this.contact).toString();
    }

    public Class getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.label.required();
    }

    public boolean isData() {
        return this.label.data();
    }

    public boolean isText() {
        return true;
    }

    public boolean isInline() {
        return true;
    }

    public String toString() {
        return this.detail.toString();
    }
}

