/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Criteria;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.Signature;
import org.simpleframework.xml.core.Variable;

class Initializer {
    private final List<Parameter> list;
    private final Constructor factory;
    private final Signature signature;

    public Initializer(Constructor factory, Signature signature) {
        this.list = signature.getParameters();
        this.signature = signature;
        this.factory = factory;
    }

    public boolean isDefault() {
        return this.signature.size() == 0;
    }

    public Parameter getParameter(String name) {
        return (Parameter)this.signature.get(name);
    }

    public Object getInstance() throws Exception {
        if (!this.factory.isAccessible()) {
            this.factory.setAccessible(true);
        }
        return this.factory.newInstance(new Object[0]);
    }

    public Object getInstance(Criteria criteria) throws Exception {
        Object[] values = this.list.toArray();
        for (int i = 0; i < this.list.size(); ++i) {
            values[i] = this.getVariable(criteria, i);
        }
        return this.getInstance(values);
    }

    private Object getVariable(Criteria criteria, int index) throws Exception {
        Parameter parameter = this.list.get(index);
        String path = parameter.getPath();
        Variable variable = criteria.remove(path);
        if (variable != null) {
            return variable.getValue();
        }
        return null;
    }

    public double getScore(Criteria criteria) throws Exception {
        Signature match = this.signature.getSignature();
        for (String name : criteria) {
            Variable label = criteria.resolve(name);
            if (label == null) continue;
            Parameter value = match.getParameter(name);
            Contact contact = label.getContact();
            if (value == null) {
                value = this.getParameter(match, label);
            }
            if (!contact.isReadOnly() || value != null) continue;
            return -1.0;
        }
        return this.getPercentage(criteria);
    }

    private Parameter getParameter(Signature match, Label label) throws Exception {
        Collection<String> options = label.getNames();
        Class type = label.getType();
        for (String option : options) {
            Class other;
            Parameter parameter = match.getParameter(option);
            if (parameter == null || !(other = parameter.getType()).isAssignableFrom(type)) continue;
            return parameter;
        }
        return null;
    }

    private double getPercentage(Criteria criteria) throws Exception {
        double score = 0.0;
        for (Parameter value : this.list) {
            String name = value.getPath();
            Variable label = criteria.resolve(name);
            if (label == null) {
                if (value.isRequired()) {
                    return -1.0;
                }
                if (!value.isPrimitive()) continue;
                return -1.0;
            }
            score += 1.0;
        }
        return this.getAdjustment(score);
    }

    private double getAdjustment(double score) {
        double adjustment = (double)this.list.size() / 1000.0;
        if (score > 0.0) {
            return adjustment + score / (double)this.list.size();
        }
        return score / (double)this.list.size();
    }

    private Object getInstance(Object[] list) throws Exception {
        if (!this.factory.isAccessible()) {
            this.factory.setAccessible(true);
        }
        return this.factory.newInstance(list);
    }

    public String toString() {
        return this.factory.toString();
    }
}

