/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.core.ClassCreator;
import org.simpleframework.xml.core.ConstructorException;
import org.simpleframework.xml.core.Creator;
import org.simpleframework.xml.core.Initializer;
import org.simpleframework.xml.core.Signature;
import org.simpleframework.xml.core.SignatureScanner;
import org.simpleframework.xml.stream.Format;

class ConstructorScanner {
    private List<Initializer> list = new ArrayList<Initializer>();
    private Initializer primary;
    private Signature registry;
    private Format format;

    public ConstructorScanner(Class type, Format format) throws Exception {
        this.registry = new Signature(type);
        this.format = format;
        this.scan(type);
    }

    public Creator getCreator() {
        return new ClassCreator(this.list, this.registry, this.primary);
    }

    private void scan(Class type) throws Exception {
        Constructor<?>[] array = type.getDeclaredConstructors();
        if (!this.isInstantiable(type)) {
            throw new ConstructorException("Can not construct inner %s", type);
        }
        for (Constructor<?> factory : array) {
            if (type.isPrimitive()) continue;
            this.scan(factory);
        }
    }

    private void scan(Constructor factory) throws Exception {
        SignatureScanner scanner = new SignatureScanner(factory, this.registry, this.format);
        if (scanner.isValid()) {
            List<Signature> list = scanner.getSignatures();
            for (Signature signature : list) {
                this.build(factory, signature);
            }
        }
    }

    private void build(Constructor factory, Signature signature) throws Exception {
        Initializer initializer = new Initializer(factory, signature);
        if (initializer.isDefault()) {
            this.primary = initializer;
        }
        this.list.add(initializer);
    }

    private boolean isInstantiable(Class type) {
        int modifiers = type.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return true;
        }
        return !type.isMemberClass();
    }
}

