/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.core.ArrayFactory;
import org.simpleframework.xml.core.ClassType;
import org.simpleframework.xml.core.CompositeArray;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.core.Factory;
import org.simpleframework.xml.core.InstantiationException;
import org.simpleframework.xml.core.Introspector;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.PrimitiveArray;
import org.simpleframework.xml.core.Qualifier;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ElementArrayLabel
implements Label {
    private Decorator decorator;
    private ElementArray label;
    private Introspector detail;
    private Class type;
    private String entry;
    private String name;

    public ElementArrayLabel(Contact contact, ElementArray label) {
        this.detail = new Introspector(contact, this);
        this.decorator = new Qualifier(contact);
        this.type = contact.getType();
        this.entry = label.entry();
        this.name = label.name();
        this.label = label;
    }

    @Override
    public Type getType(Class type) {
        return this.getContact();
    }

    @Override
    public Label getLabel(Class type) {
        return this;
    }

    @Override
    public Set<String> getVariants() throws Exception {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getVariants(Context context) throws Exception {
        return Collections.emptySet();
    }

    @Override
    public Decorator getDecorator() throws Exception {
        return this.decorator;
    }

    @Override
    public Converter getConverter(Context context) throws Exception {
        String entry = this.getEntry(context);
        Contact contact = this.getContact();
        if (!this.type.isArray()) {
            throw new InstantiationException("Type is not an array %s for %s", this.type, contact);
        }
        return this.getConverter(context, entry);
    }

    private Converter getConverter(Context context, String name) throws Exception {
        Type entry = this.getDependent();
        Contact type = this.getContact();
        if (!context.isPrimitive(entry)) {
            return new CompositeArray(context, type, entry, name);
        }
        return new PrimitiveArray(context, type, entry, name);
    }

    private String getEntry(Context context) throws Exception {
        Style style = context.getStyle();
        String entry = this.getEntry();
        return style.getElement(entry);
    }

    @Override
    public String getName(Context context) throws Exception {
        Style style = context.getStyle();
        String name = this.detail.getName();
        return style.getElement(name);
    }

    @Override
    public Object getEmpty(Context context) throws Exception {
        ClassType array = new ClassType(this.type);
        ArrayFactory factory = new ArrayFactory(context, array);
        if (!this.label.empty()) {
            return ((Factory)factory).getInstance();
        }
        return null;
    }

    @Override
    public String getEntry() throws Exception {
        if (this.detail.isEmpty(this.entry)) {
            this.entry = this.detail.getEntry();
        }
        return this.entry;
    }

    @Override
    public String getName() throws Exception {
        return this.detail.getName();
    }

    @Override
    public Annotation getAnnotation() {
        return this.label;
    }

    @Override
    public Type getDependent() {
        Class<?> entry = this.type.getComponentType();
        if (entry == null) {
            return new ClassType(this.type);
        }
        return new ClassType(entry);
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public Contact getContact() {
        return this.detail.getContact();
    }

    @Override
    public String getPath() {
        return this.detail.getPath();
    }

    @Override
    public String getOverride() {
        return this.name;
    }

    @Override
    public boolean isAttribute() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public boolean isRequired() {
        return this.label.required();
    }

    @Override
    public boolean isData() {
        return this.label.data();
    }

    @Override
    public boolean isInline() {
        return false;
    }

    @Override
    public String toString() {
        return this.detail.toString();
    }
}

