/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Map;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.core.AnnotationHandler;

class AnnotationFactory {
    AnnotationFactory() {
    }

    public Annotation getInstance(Class type) throws Exception {
        ClassLoader loader = this.getClassLoader();
        if (Map.class.isAssignableFrom(type)) {
            return this.getInstance(loader, ElementMap.class);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return this.getInstance(loader, ElementList.class);
        }
        if (type.isArray()) {
            return this.getInstance(loader, ElementArray.class);
        }
        return this.getInstance(loader, Element.class);
    }

    private Annotation getInstance(ClassLoader loader, Class label) throws Exception {
        AnnotationHandler handler = new AnnotationHandler(label);
        Class[] list = new Class[]{label};
        return (Annotation)Proxy.newProxyInstance(loader, list, (InvocationHandler)handler);
    }

    private ClassLoader getClassLoader() throws Exception {
        return AnnotationFactory.class.getClassLoader();
    }
}

