/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.strategy;

import java.util.Map;
import org.simpleframework.xml.strategy.Contract;
import org.simpleframework.xml.strategy.ReadGraph;
import org.simpleframework.xml.strategy.ReadState;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.strategy.Value;
import org.simpleframework.xml.strategy.WriteGraph;
import org.simpleframework.xml.strategy.WriteState;
import org.simpleframework.xml.stream.NodeMap;

public class CycleStrategy
implements Strategy {
    private static final String REFER = "reference";
    private static final String MARK = "id";
    private static final String LENGTH = "length";
    private static final String LABEL = "class";
    private WriteState write;
    private ReadState read;
    private Contract contract;

    public CycleStrategy() {
        this(MARK, REFER);
    }

    public CycleStrategy(String mark, String refer) {
        this(mark, refer, LABEL);
    }

    public CycleStrategy(String mark, String refer, String label) {
        this(mark, refer, label, LENGTH);
    }

    public CycleStrategy(String mark, String refer, String label, String length) {
        this.contract = new Contract(mark, refer, label, length);
        this.write = new WriteState(this.contract);
        this.read = new ReadState(this.contract);
    }

    public Value getRoot(Type type, NodeMap node, Map map) throws Exception {
        return this.getElement(type, node, map);
    }

    public Value getElement(Type type, NodeMap node, Map map) throws Exception {
        ReadGraph graph = this.read.find(map);
        if (graph != null) {
            return graph.getElement(type, node);
        }
        return null;
    }

    public boolean setRoot(Type type, Object value, NodeMap node, Map map) {
        return this.setElement(type, value, node, map);
    }

    public boolean setElement(Type type, Object value, NodeMap node, Map map) {
        WriteGraph graph = this.write.find(map);
        if (graph != null) {
            return graph.setElement(type, value, node);
        }
        return false;
    }
}

