/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.strategy;

import java.lang.reflect.Array;
import java.util.IdentityHashMap;
import org.simpleframework.xml.strategy.Contract;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.NodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WriteGraph
extends IdentityHashMap<Object, String> {
    private String length;
    private String label;
    private String mark;
    private String refer;

    public WriteGraph(Contract contract) {
        this.refer = contract.getReference();
        this.mark = contract.getIdentity();
        this.length = contract.getLength();
        this.label = contract.getLabel();
    }

    public boolean setElement(Type type, Object value, NodeMap node) {
        Class actual = value.getClass();
        Class expect = type.getType();
        Class real = actual;
        if (actual.isArray()) {
            real = this.setArray(actual, value, node);
        }
        if (actual != expect) {
            node.put(this.label, real.getName());
        }
        return this.setReference(value, node);
    }

    private boolean setReference(Object value, NodeMap node) {
        String name = (String)this.get(value);
        if (name != null) {
            node.put(this.refer, name);
            return true;
        }
        String unique = this.getKey();
        node.put(this.mark, unique);
        this.put(value, unique);
        return false;
    }

    private Class setArray(Class field, Object value, NodeMap node) {
        int size = Array.getLength(value);
        if (!this.containsKey(value)) {
            node.put(this.length, String.valueOf(size));
        }
        return field.getComponentType();
    }

    private String getKey() {
        return String.valueOf(this.size());
    }
}

