/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.convert;

import java.util.Map;
import org.simpleframework.xml.convert.Converter;
import org.simpleframework.xml.convert.Reference;
import org.simpleframework.xml.convert.Registry;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.TreeStrategy;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.strategy.Value;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.NodeMap;
import org.simpleframework.xml.stream.OutputNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryStrategy
implements Strategy {
    private final Registry registry;
    private final Strategy strategy;

    public RegistryStrategy(Registry registry) {
        this(registry, new TreeStrategy());
    }

    public RegistryStrategy(Registry registry, Strategy strategy) {
        this.registry = registry;
        this.strategy = strategy;
    }

    @Override
    public Value getRoot(Type type, NodeMap<InputNode> node, Map map) throws Exception {
        return this.getElement(type, node, map);
    }

    @Override
    public Value getElement(Type type, NodeMap<InputNode> node, Map map) throws Exception {
        Value value = this.strategy.getElement(type, node, map);
        if (this.isReference(value)) {
            return value;
        }
        return this.getElement(type, node, value);
    }

    private Value getElement(Type type, NodeMap<InputNode> node, Value value) throws Exception {
        Converter converter = this.getConverter(type, value);
        InputNode source = node.getNode();
        if (converter != null) {
            Object data = converter.read(source);
            if (value != null) {
                value.setValue(data);
            }
            return new Reference(value, data);
        }
        return value;
    }

    @Override
    public boolean setRoot(Type type, Object value, NodeMap<OutputNode> node, Map map) throws Exception {
        return this.setElement(type, value, node, map);
    }

    @Override
    public boolean setElement(Type type, Object value, NodeMap<OutputNode> node, Map map) throws Exception {
        boolean reference = this.strategy.setElement(type, value, node, map);
        if (!reference) {
            return this.setElement(type, value, node);
        }
        return reference;
    }

    private boolean setElement(Type type, Object value, NodeMap<OutputNode> node) throws Exception {
        Converter converter = this.getConverter(type, value);
        OutputNode source = node.getNode();
        if (converter != null) {
            converter.write(source, value);
            return true;
        }
        return false;
    }

    private Converter getConverter(Type type, Value value) throws Exception {
        Class real = type.getType();
        if (value != null) {
            real = value.getType();
        }
        return this.registry.lookup(real);
    }

    private Converter getConverter(Type type, Object value) throws Exception {
        Class<?> real = type.getType();
        if (value != null) {
            real = value.getClass();
        }
        return this.registry.lookup(real);
    }

    private boolean isReference(Value value) {
        return value != null && value.isReference();
    }
}

