/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.reflect.Array;
import org.simpleframework.xml.core.ArrayFactory;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Instance;
import org.simpleframework.xml.core.Primitive;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

class PrimitiveArray
implements Converter {
    private final ArrayFactory factory;
    private final Primitive root;
    private final String parent;
    private final Class entry;

    public PrimitiveArray(Context context, Class field, Class entry, String parent) {
        this.factory = new ArrayFactory(context, field);
        this.root = new Primitive(context, entry, null);
        this.parent = parent;
        this.entry = entry;
    }

    public Object read(InputNode node) throws Exception {
        Instance type = this.factory.getInstance(node);
        Object list = type.getInstance();
        if (!type.isReference()) {
            return this.read(node, list);
        }
        return list;
    }

    public Object read(InputNode node, Object list) throws Exception {
        int i = 0;
        InputNode next;
        while ((next = node.getNext()) != null) {
            Array.set(list, i, this.root.read(next));
            ++i;
        }
        return list;
    }

    public boolean validate(InputNode node) throws Exception {
        Instance value = this.factory.getInstance(node);
        if (!value.isReference()) {
            Object result = value.setInstance(null);
            Class expect = value.getType();
            return this.validate(node, expect);
        }
        return true;
    }

    private boolean validate(InputNode node, Class type) throws Exception {
        int i = 0;
        InputNode next;
        while ((next = node.getNext()) != null) {
            this.root.validate(next);
            ++i;
        }
        return true;
    }

    public void write(OutputNode node, Object source) throws Exception {
        OutputNode child;
        int size = Array.getLength(source);
        for (int i = 0; i < size && (child = node.getChild(this.parent)) != null; ++i) {
            this.write(child, source, i);
        }
    }

    private void write(OutputNode node, Object source, int index) throws Exception {
        Object item = Array.get(source, index);
        if (item != null && !this.isOverridden(node, item)) {
            this.root.write(node, item);
        }
    }

    private boolean isOverridden(OutputNode node, Object value) throws Exception {
        return this.factory.setOverride(this.entry, value, node);
    }
}

