/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.core.CompositeKey;
import org.simpleframework.xml.core.CompositeValue;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.PrimitiveKey;
import org.simpleframework.xml.core.PrimitiveValue;

class Entry {
    private static final String DEFAULT_NAME = "entry";
    private ElementMap label;
    private Contact contact;
    private Class valueType;
    private Class keyType;
    private String entry;
    private String value;
    private String key;
    private boolean attribute;

    public Entry(Contact contact, ElementMap label) {
        this.attribute = label.attribute();
        this.entry = label.entry();
        this.value = label.value();
        this.key = label.key();
        this.key = label.key();
        this.contact = contact;
        this.label = label;
    }

    protected Class getKeyType() throws Exception {
        if (this.keyType != null) {
            return this.keyType;
        }
        Class keyType = this.label.keyType();
        if (keyType == Void.TYPE) {
            keyType = this.getDependent(0);
        }
        return keyType;
    }

    public Converter getKey(Context context) throws Exception {
        Class type = this.getKeyType();
        if (context.isPrimitive(type)) {
            return new PrimitiveKey(context, this, type);
        }
        return new CompositeKey(context, this, type);
    }

    public boolean isAttribute() {
        return this.attribute;
    }

    protected Class getValueType() throws Exception {
        if (this.valueType != null) {
            return this.valueType;
        }
        Class valueType = this.label.valueType();
        if (valueType == Void.TYPE) {
            valueType = this.getDependent(1);
        }
        return valueType;
    }

    public Converter getValue(Context context) throws Exception {
        Class value = this.getValueType();
        if (context.isPrimitive(value)) {
            return new PrimitiveValue(context, this, value);
        }
        return new CompositeValue(context, this, value);
    }

    public boolean isInline() throws Exception {
        return this.isAttribute();
    }

    private Class getDependent(int index) throws Exception {
        Class[] list = this.contact.getDependents();
        if (list.length < index) {
            throw new PersistenceException("Could not find dependent at index %s", index);
        }
        return list[index];
    }

    public String getKey() throws Exception {
        if (this.key == null) {
            return this.key;
        }
        if (this.isEmpty(this.key)) {
            this.key = null;
        }
        return this.key;
    }

    public String getValue() throws Exception {
        if (this.value == null) {
            return this.value;
        }
        if (this.isEmpty(this.value)) {
            this.value = null;
        }
        return this.value;
    }

    public String getEntry() throws Exception {
        if (this.entry == null) {
            return this.entry;
        }
        if (this.isEmpty(this.entry)) {
            this.entry = DEFAULT_NAME;
        }
        return this.entry;
    }

    private boolean isEmpty(String value) {
        return value.length() == 0;
    }
}

