/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.core.Composite;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.core.Factory;
import org.simpleframework.xml.core.RootException;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Style;

class Traverser {
    private final Context context;
    private final Style style;

    public Traverser(Context context) {
        this.style = context.getStyle();
        this.context = context;
    }

    public Object read(InputNode node, Class type) throws Exception {
        Composite factory = this.getComposite(type);
        Object value = factory.read(node);
        Class<?> real = value.getClass();
        return this.read(node, real, value);
    }

    public Object read(InputNode node, Object value) throws Exception {
        Class<?> type = value.getClass();
        Composite factory = this.getComposite(type);
        Object real = factory.read(node, value);
        return this.read(node, type, real);
    }

    private Object read(InputNode node, Class type, Object value) throws Exception {
        String root = this.getName(type);
        if (root == null) {
            throw new RootException("Root annotation required for %s", type);
        }
        return value;
    }

    public boolean validate(InputNode node, Class type) throws Exception {
        Composite factory = this.getComposite(type);
        String root = this.getName(type);
        if (root == null) {
            throw new RootException("Root annotation required for %s", type);
        }
        return factory.validate(node);
    }

    public void write(OutputNode node, Object source) throws Exception {
        this.write(node, source, source.getClass());
    }

    public void write(OutputNode node, Object source, Class expect) throws Exception {
        Class<?> type = source.getClass();
        String root = this.getName(type);
        if (root == null) {
            throw new RootException("Root annotation required for %s", type);
        }
        this.write(node, source, expect, root);
    }

    public void write(OutputNode node, Object source, Class expect, String name) throws Exception {
        OutputNode child = node.getChild(name);
        if (source != null) {
            Class<?> type = source.getClass();
            if (!this.context.setOverride(expect, source, child)) {
                Composite convert = this.getComposite(type);
                Decorator decorator = this.getDecorator(type);
                decorator.decorate(child);
                convert.write(child, source);
            }
        }
        child.commit();
    }

    private Decorator getDecorator(Class type) throws Exception {
        return this.context.getDecorator(type);
    }

    private Composite getComposite(Class type) throws Exception {
        return new Composite(this.context, type);
    }

    protected String getName(Class type) throws Exception {
        String root = Factory.getName(type);
        String name = this.style.getElement(root);
        return name;
    }
}

