/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.Map;
import org.simpleframework.xml.Version;
import org.simpleframework.xml.core.Conduit;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.LabelMap;
import org.simpleframework.xml.core.Scanner;
import org.simpleframework.xml.core.Session;

class Schema {
    private Decorator decorator;
    private LabelMap attributes;
    private LabelMap elements;
    private Version revision;
    private Conduit conduit;
    private Session session;
    private Label version;
    private Label text;
    private Map table;
    private boolean primitive;

    public Schema(Scanner schema, Context context) throws Exception {
        this.attributes = schema.getAttributes(context);
        this.elements = schema.getElements(context);
        this.revision = schema.getRevision();
        this.decorator = schema.getDecorator();
        this.primitive = schema.isPrimitive();
        this.conduit = schema.getConduit();
        this.session = context.getSession();
        this.version = schema.getVersion();
        this.text = schema.getText();
        this.table = this.session.getMap();
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public Label getVersion() {
        return this.version;
    }

    public Version getRevision() {
        return this.revision;
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public LabelMap getAttributes() {
        return this.attributes;
    }

    public LabelMap getElements() {
        return this.elements;
    }

    public Label getText() {
        return this.text;
    }

    public Object replace(Object source) throws Exception {
        return this.conduit.replace(source, this.table);
    }

    public Object resolve(Object source) throws Exception {
        return this.conduit.resolve(source, this.table);
    }

    public void commit(Object source) throws Exception {
        this.conduit.commit(source, this.table);
    }

    public void validate(Object source) throws Exception {
        this.conduit.validate(source, this.table);
    }

    public void persist(Object source) throws Exception {
        this.conduit.persist(source, this.table);
    }

    public void complete(Object source) throws Exception {
        this.conduit.complete(source, this.table);
    }
}

