/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.Version;
import org.simpleframework.xml.core.AttributeException;
import org.simpleframework.xml.core.ClassScanner;
import org.simpleframework.xml.core.Conduit;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.core.ElementException;
import org.simpleframework.xml.core.FieldScanner;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.LabelFactory;
import org.simpleframework.xml.core.LabelMap;
import org.simpleframework.xml.core.MethodScanner;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.TextException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Scanner {
    private ClassScanner scanner;
    private LabelMap attributes;
    private LabelMap elements;
    private Label version;
    private Label text;
    private String name;
    private boolean primitive;

    public Scanner(Class type) throws Exception {
        this.scanner = new ClassScanner(type);
        this.attributes = new LabelMap(this);
        this.elements = new LabelMap(this);
        this.scan(type);
    }

    public Version getRevision() {
        if (this.version != null) {
            return this.version.getContact().getAnnotation(Version.class);
        }
        return null;
    }

    public Decorator getDecorator() {
        return this.scanner.getDecorator();
    }

    public LabelMap getAttributes(Context context) throws Exception {
        return this.attributes.clone(context);
    }

    public LabelMap getElements(Context context) throws Exception {
        return this.elements.clone(context);
    }

    public Label getVersion() {
        return this.version;
    }

    public Label getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public Conduit getConduit() {
        return new Conduit(this);
    }

    public Method getCommit() {
        return this.scanner.getCommit();
    }

    public Method getValidate() {
        return this.scanner.getValidate();
    }

    public Method getPersist() {
        return this.scanner.getPersist();
    }

    public Method getComplete() {
        return this.scanner.getComplete();
    }

    public Method getReplace() {
        return this.scanner.getReplace();
    }

    public Method getResolve() {
        return this.scanner.getResolve();
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    private boolean isEmpty() {
        Root root = this.scanner.getRoot();
        if (!this.elements.isEmpty()) {
            return false;
        }
        if (!this.attributes.isEmpty()) {
            return false;
        }
        if (this.text != null) {
            return false;
        }
        return root == null;
    }

    public boolean isStrict() {
        return this.scanner.isStrict();
    }

    private void scan(Class type) throws Exception {
        this.root(type);
        this.order(type);
        this.field(type);
        this.method(type);
        this.validate(type);
    }

    private void validate(Class type) throws Exception {
        Order order = this.scanner.getOrder();
        if (order != null) {
            this.validateElements(type, order);
            this.validateAttributes(type, order);
        }
        this.validateText(type);
    }

    private void validateText(Class type) throws Exception {
        if (this.text != null) {
            if (!this.elements.isEmpty()) {
                throw new TextException("Elements used with %s in %s", this.text, type);
            }
        } else {
            this.primitive = this.isEmpty();
        }
    }

    private void validateElements(Class type, Order order) throws Exception {
        for (String name : order.elements()) {
            Label label = (Label)this.elements.get(name);
            if (label != null) continue;
            throw new ElementException("Ordered element '%s' missing for %s", name, type);
        }
    }

    private void validateAttributes(Class type, Order order) throws Exception {
        for (String name : order.attributes()) {
            Label label = (Label)this.attributes.get(name);
            if (label != null) continue;
            throw new AttributeException("Ordered attribute '%s' missing for %s", name, type);
        }
    }

    private void root(Class<?> type) {
        String real = type.getSimpleName();
        Root root = this.scanner.getRoot();
        String text = real;
        if (root != null) {
            text = root.name();
            if (this.isEmpty(text)) {
                text = Introspector.decapitalize(real);
            }
            this.name = text.intern();
        }
    }

    private void order(Class<?> type) {
        Order order = this.scanner.getOrder();
        if (order != null) {
            for (String name : order.elements()) {
                this.elements.put(name, null);
            }
            for (String name : order.attributes()) {
                this.attributes.put(name, null);
            }
        }
    }

    private boolean isEmpty(String value) {
        return value.length() == 0;
    }

    public void field(Class type) throws Exception {
        FieldScanner list = new FieldScanner(type);
        for (Contact contact : list) {
            this.scan(contact, contact.getAnnotation());
        }
    }

    public void method(Class type) throws Exception {
        MethodScanner list = new MethodScanner(type);
        for (Contact contact : list) {
            this.scan(contact, contact.getAnnotation());
        }
    }

    private void scan(Contact field, Annotation label) throws Exception {
        if (label instanceof Attribute) {
            this.process(field, label, this.attributes);
        }
        if (label instanceof ElementList) {
            this.process(field, label, this.elements);
        }
        if (label instanceof ElementArray) {
            this.process(field, label, this.elements);
        }
        if (label instanceof ElementMap) {
            this.process(field, label, this.elements);
        }
        if (label instanceof Element) {
            this.process(field, label, this.elements);
        }
        if (label instanceof Version) {
            this.version(field, label);
        }
        if (label instanceof Text) {
            this.text(field, label);
        }
    }

    private void text(Contact field, Annotation type) throws Exception {
        Label label = LabelFactory.getInstance(field, type);
        if (this.text != null) {
            throw new TextException("Multiple text annotations in %s", type);
        }
        this.text = label;
    }

    private void version(Contact field, Annotation type) throws Exception {
        Label label = LabelFactory.getInstance(field, type);
        if (this.version != null) {
            throw new AttributeException("Multiple version annotations in %s", type);
        }
        this.version = label;
    }

    private void process(Contact field, Annotation type, LabelMap map) throws Exception {
        Label label = LabelFactory.getInstance(field, type);
        String name = label.getName();
        if (map.get(name) != null) {
            throw new PersistenceException("Annotation of name '%s' declared twice", name);
        }
        map.put(name, label);
    }
}

