/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.Element;
import org.simpleframework.xml.core.Composite;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.Primitive;
import org.simpleframework.xml.core.Qualifier;
import org.simpleframework.xml.core.Signature;
import org.simpleframework.xml.stream.Style;

class ElementLabel
implements Label {
    private Decorator decorator;
    private Signature detail;
    private Element label;
    private Class type;
    private String name;

    public ElementLabel(Contact contact, Element label) {
        this.detail = new Signature(contact, this);
        this.decorator = new Qualifier(contact);
        this.type = contact.getType();
        this.name = label.name();
        this.label = label;
    }

    public Decorator getDecorator() throws Exception {
        return this.decorator;
    }

    public Converter getConverter(Context context) throws Exception {
        if (context.isPrimitive(this.type)) {
            return new Primitive(context, this.type);
        }
        return new Composite(context, this.type);
    }

    public String getName(Context context) throws Exception {
        Style style = context.getStyle();
        String name = this.detail.getName();
        return style.getElement(name);
    }

    public Object getEmpty(Context context) {
        return null;
    }

    public String getName() throws Exception {
        return this.detail.getName();
    }

    public Contact getContact() {
        return this.detail.getContact();
    }

    public String getOverride() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public String getEntry() {
        return null;
    }

    public Class getDependant() {
        return null;
    }

    public boolean isRequired() {
        return this.label.required();
    }

    public boolean isData() {
        return this.label.data();
    }

    public boolean isInline() {
        return false;
    }

    public String toString() {
        return this.detail.toString();
    }
}

