/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.reflect.Method;
import java.util.Map;
import org.simpleframework.xml.core.Scanner;

class Conduit {
    private final Method commit;
    private final Method validate;
    private final Method persist;
    private final Method complete;
    private final Method replace;
    private final Method resolve;

    public Conduit(Scanner schema) {
        this.validate = schema.getValidate();
        this.complete = schema.getComplete();
        this.replace = schema.getReplace();
        this.resolve = schema.getResolve();
        this.persist = schema.getPersist();
        this.commit = schema.getCommit();
    }

    public Object replace(Object source, Map map) throws Exception {
        if (this.replace != null) {
            return this.invoke(source, this.replace, map);
        }
        return source;
    }

    public Object resolve(Object source, Map map) throws Exception {
        if (this.resolve != null) {
            return this.invoke(source, this.resolve, map);
        }
        return source;
    }

    public void commit(Object source, Map map) throws Exception {
        if (this.commit != null) {
            this.invoke(source, this.commit, map);
        }
    }

    public void validate(Object source, Map map) throws Exception {
        if (this.validate != null) {
            this.invoke(source, this.validate, map);
        }
    }

    public void persist(Object source, Map map) throws Exception {
        if (this.persist != null) {
            this.invoke(source, this.persist, map);
        }
    }

    public void complete(Object source, Map map) throws Exception {
        if (this.complete != null) {
            this.invoke(source, this.complete, map);
        }
    }

    private Object invoke(Object source, Method method, Map map) throws Exception {
        if (source == null) {
            return null;
        }
        if (this.isContextual(method)) {
            return method.invoke(source, map);
        }
        return method.invoke(source, new Object[0]);
    }

    private boolean isContextual(Method method) throws Exception {
        Class<?>[] list = method.getParameterTypes();
        if (list.length == 1) {
            return Map.class.equals(list[0]);
        }
        return false;
    }
}

